<?php

class WC_Integration_Eliides_Compucash extends WC_Integration {


    public function __construct() {
        $this->id                 = 'compucash';
        $this->method_title       = 'Compucash';
        $this->method_description = null;

        $this->init_form_fields();
        $this->init_settings();

        add_action( 'woocommerce_update_options_integration_' .  $this->id, array( $this, 'process_admin_options' ) );
    }

    public function process_admin_options()
    {
        $this->init_settings();

        $post_data = $this->get_post_data();
        update_option('veebiekspert_module_compucash_api_key', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_compucash_api_key']));
        update_option('veebiekspert_module_compucash_params', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_compucash_params']));

        $activeModules = (array) get_option('veebiekspert_active_module', []);
        $module = 'compucash';

        if (!empty($post_data['is_module_active'])) {
            if (!in_array($module, $activeModules)) {
                $activeModules[] = $module;
                update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
            }
        }
        else {
            $key = array_search($module, $activeModules);
            if (false !== $key) {
                unset($activeModules[$key]);
                update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
            }
        }

    }

    public function admin_options() {
        parent::admin_options();
        $compucash = get_option('veebiekspert_module_compucash_params', []);
        $veebiekspert_active_module = (array) get_option('veebiekspert_active_module', []);
        ?>
        <div class="veebiekspert-setting-block">

            <input type="hidden" name="is_module_active" value="0" />
            <h2><label><input type="checkbox" name="is_module_active"<?php if (in_array('compucash', $veebiekspert_active_module)): ?> checked<?php endif; ?> value="1" /> Aktiivne</label></h2>

            <div class="settings-block-inner">
                <div class="ve-form-group">
                    <label>E-liides litsentsi võti</label>
                    <input type="text" id="veebiekspert_module_compucash_api_key" name="veebiekspert_module_compucash_api_key" value="<?php echo get_option('veebiekspert_module_compucash_api_key'); ?>" />
                    <a href="https://www.e-liides.ee" target="_blank">Registreeri võti (7 päeva tasuta)</a>
                </div>

                <div class="ve-form-group">
                    <label>CompuCash client ID</label>
                    <input type="text" name="veebiekspert_module_compucash_params[client_id]" value="<?php echo @esc_html(eliides_arr_get($compucash, ['client_id'])); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>CompuCash client secret</label>
                    <input type="text" name="veebiekspert_module_compucash_params[client_secret]" value="<?php echo @esc_html(eliides_arr_get($compucash, ['client_secret'])); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Arve saatmise hetk</label>

                    <?php

                    $options = array(
                        'woocommerce_order_status_on-hold' => 'Ootel',
                        'woocommerce_order_status_processing' => 'Töötluses',
                        'woocommerce_order_status_completed' => 'Tellimus täidetud',
                    );

                    ?>

                    <select name="veebiekspert_module_compucash_params[invoice_trigger]">
                        <?php foreach ($options as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($compucash, ['invoice_trigger'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

            </div>

        </div>

        <?php
    }
}