<?php

class WC_Integration_Eliides_Erply extends WC_Integration {


    public function __construct() {
        $this->id                 = 'erply';
        $this->method_title       = 'Erply';
        $this->method_description = null;

        $this->init_form_fields();
        $this->init_settings();

        add_action( 'woocommerce_update_options_integration_' .  $this->id, array( $this, 'process_admin_options' ) );
    }

    public function process_admin_options()
    {
        $this->init_settings();

        $post_data = $this->get_post_data();
        update_option('veebiekspert_module_erply_api_key', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_erply_api_key']));
        update_option('veebiekspert_module_erply_internal_username', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_erply_internal_username']));
        update_option('veebiekspert_module_erply_internal_password', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_erply_internal_password']));
        update_option('veebiekspert_module_erply_internal_client_code', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_erply_internal_client_code']));
        update_option('veebiekspert_module_erply_trigger', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_erply_trigger']));
        update_option('veebiekspert_module_erply_taxes', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_erply_taxes']));
        update_option('veebiekspert_module_erply_options', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_erply_options']));

        $activeModules = (array) get_option('veebiekspert_active_module', []);
        $module = 'erply';

        if (!empty($post_data['is_module_active'])) {
            if (!in_array($module, $activeModules)) {
                $activeModules[] = $module;
                update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
            }
        }
        else {
            $key = array_search($module, $activeModules);
            if (false !== $key) {
                unset($activeModules[$key]);
                update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
            }
        }

    }

    public function admin_options() {
        parent::admin_options();

        $taxes = array(
            0 => array(
                'label' => '0%',
                'rate' => 0,
            )
        );

        if (defined('WC_ABSPATH')) {

            $allShippingPackages = WC()->shipping()->get_shipping_methods();

            $zones = WC_Shipping_Zones::get_zones();
            foreach ($zones as $zone) {
                foreach ($zone['shipping_methods'] as $shipMethod) {
                    $shipObj = new stdClass();
                    $shipObj->id = $shipMethod->id . ':' . $shipMethod->instance_id;
                    $shipObj->title = $shipMethod->title;
                    $allShippingPackages[] = $shipObj;
                }
            }


            foreach (WC_Tax::get_rates() as $taxId => $tax) {
                $taxes[$taxId] = $tax;
            }

            if (class_exists('WC_Tax')) {
                if (method_exists('WC_Tax', 'get_tax_class_slugs')) {

                    $taxClasses = array_merge(array(''), WC_Tax::get_tax_class_slugs());

                    foreach ($taxClasses as $taxSlug) {
                        foreach (WC_Tax::get_rates_for_tax_class($taxSlug) as $taxId => $tax) {
                            $taxes[$taxId] = array(
                                'label' => implode(', ', array_filter(array($taxSlug, $tax->tax_rate_name, $tax->tax_rate_country))),
                                'rate' => $tax->tax_rate,
                            );
                        }

                    }

                }
            }

        }

        $veebiekspert_active_module = (array) get_option('veebiekspert_active_module');
        $erplyOptions = (array) get_option('veebiekspert_module_erply_options');
        if (!isset($erplyOptions['customer_id'])) {
            $erplyOptions['customer_id'] = '';
        }

        if (!$warehouses = Veebiekspert_Modules()->getErply()->getWarehouses()) {
            $warehouses = [];
        }
        ?>
        <div class="veebiekspert-setting-block">

            <input type="hidden" name="is_module_active" value="0" />
            <h2><label><input type="checkbox" name="is_module_active"<?php if (in_array('erply', $veebiekspert_active_module)): ?> checked<?php endif; ?> value="1" /> Aktiivne</label></h2>

            <div class="settings-block-inner">
                <div class="ve-form-group">
                    <label>E-liides litsentsi võti</label>
                    <input type="text" id="veebiekspert_module_erply_api_key" name="veebiekspert_module_erply_api_key" value="<?php echo get_option('veebiekspert_module_erply_api_key'); ?>" />
                    <a href="https://www.e-liides.ee" target="_blank">Registreeri võti (7 päeva tasuta)</a>
                </div>

                <div class="ve-form-group">
                    <label>ERPLY kliendikood</label>
                    <input type="text" id="veebiekspert_module_erply_internal_client_code" name="veebiekspert_module_erply_internal_client_code" value="<?php echo get_option('veebiekspert_module_erply_internal_client_code'); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>ERPLY kasutaja</label>
                    <input type="text" id="veebiekspert_module_erply_internal_username" name="veebiekspert_module_erply_internal_username" value="<?php echo get_option('veebiekspert_module_erply_internal_username'); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>ERPLY parool</label>
                    <input type="password" id="veebiekspert_module_erply_internal_password" name="veebiekspert_module_erply_internal_password" value="<?php echo get_option('veebiekspert_module_erply_internal_password'); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Arve koostaja ID (valikuline, Erply kasutaja ID, kellena määratakse arve koostaja)</label>
                    <input type="text" name="veebiekspert_module_erply_options[employee_id]" value="<?php echo esc_html(eliides_arr_get($erplyOptions, ['employee_id'])); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Customer ID (täida ainult kui alati sama isik läheb erply-sse)</label>
                    <input type="text" name="veebiekspert_module_erply_options[customer_id]" value="<?php echo esc_html(eliides_arr_get($erplyOptions, ['customer_id'])); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Tootekoodi väli (täida ainult erandjuhul)</label>
                    <input type="text" name="veebiekspert_module_erply_options[sku_field]" value="<?php echo esc_html(eliides_arr_get($erplyOptions, ['sku_field'])); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Arve saatmise hetk</label>

                    <?php

                    $options = array(
                        'woocommerce_order_status_on-hold' => 'Ootel',
                        'woocommerce_order_status_processing' => 'Töötluses',
                        'woocommerce_order_status_completed' => 'Tellimus täidetud',
                    );

                    $selected = get_option('veebiekspert_module_erply_trigger', 'woocommerce_order_status_completed');
                    ?>

                    <select name="veebiekspert_module_erply_trigger">
                        <?php foreach ($options as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="ve-form-group">
                    <label>Põhiladu</label>

                    <?php
                    $selected = eliides_arr_get($erplyOptions, ['warehouse_id']);
                    ?>

                    <select name="veebiekspert_module_erply_options[warehouse_id]">
                        <option value=""></option>
                        <?php foreach ($warehouses as $i): ?>
                            <option value="<?php echo $i['warehouseID']; ?>"<?php if ($i['warehouseID'] == $selected): ?> selected<?php endif; ?>><?php echo esc_html($i['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="ve-form-group">
                    <span style="color: #cc0808; font-weight: bold;">Laoseisu uuendamiseks</span> tuleb lisada järgnev link serveri crontabi:<br />
                    <a href="<?php echo get_site_url(); ?>/?eliides_sync_erply" target="_blank"><?php echo get_site_url(); ?>/?eliides_sync_erply</a>
                </div>

                <?php
                $yesNoOptions = array(
                    'outofstock' => 'Laost otsas',
                    'onbackorder' => 'Järeltellimisel',
                );
                ?>

                <div class="ve-form-group">
                    <label>Laost otsas toodete olek</label>
                    <select name="veebiekspert_module_erply_options[zero_stock_status]">
                        <?php foreach ($yesNoOptions as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($erplyOptions, ['zero_stock_status'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <?php
                $yesNoOptions = array(
                    'no' => 'Ei luba hindasi uuendada',
                    'yes' => 'Luba hindade uuendamine',
                );
                ?>

                <div class="ve-form-group">
                    <label>Hindade uuendamine lubatud</label>
                    <select name="veebiekspert_module_erply_options[allow_price_update]">
                        <?php foreach ($yesNoOptions as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($erplyOptions, ['allow_price_update'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <?php
                $yesNoOptions = array(
                    '1' => 'Kinnitatud olekus',
                    '0' => 'Kinnitamata olekus',
                );
                ?>

                <div class="ve-form-group">
                    <label>Arve kinnitamise olek</label>
                    <select name="veebiekspert_module_erply_options[confirm_invoice]">
                        <?php foreach ($yesNoOptions as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($erplyOptions, ['confirm_invoice'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <?php if (defined('WC_ABSPATH')): ?>

                    <?php

                    if (!$erplyTaxes = Veebiekspert_Modules()->getErply()->getTaxes()) {
                        $erplyTaxes = [];
                    }
                    $erplyTaxSettings = (array) get_option('veebiekspert_module_erply_taxes');

                    ?>

                    <table class="widefat fixed" style="margin-top: 20px;">
                        <thead>
                        <tr>
                            <th>Maksu ID</th>
                            <th>Maksu %</th>
                            <th>Nimetus</th>
                            <th>Vaste</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($taxes as $taxId => $tax): ?>
                            <tr>
                                <td><?php echo $taxId; ?></td>
                                <td><?php echo $tax['rate']; ?></td>
                                <td><?php echo @esc_html($tax['label']); ?></td>
                                <td>
                                    <select name="veebiekspert_module_erply_taxes[<?php echo $taxId; ?>]">
                                        <?php foreach ($erplyTaxes as $erplyTax): ?>
                                            <option value="<?php echo $erplyTax['id']; ?>"<?php if (isset($erplyTaxSettings[$taxId]) && $erplyTax['id'] == $erplyTaxSettings[$taxId]): ?> selected<?php endif; ?>><?php echo @esc_html($erplyTax['name'] . ' (' . $erplyTax['rate'] . '%)'); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        <tr>
                            <th colspan="3">Puuduva maksu vaste (peaks olema 0%)</th>
                            <td>
                                <select name="veebiekspert_module_erply_taxes[missing_vat]">
                                    <?php foreach ($erplyTaxes as $erplyTax): $taxId = 'missing_vat'; ?>
                                        <option value="<?php echo $erplyTax['id']; ?>"<?php if (isset($erplyTaxSettings[$taxId]) && $erplyTax['id'] == $erplyTaxSettings[$taxId]): ?> selected<?php endif; ?>><?php echo @esc_html($erplyTax['name'] . ' (' . $erplyTax['rate'] . '%)'); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                        </tr>
                        </tbody>
                    </table>

                    <?php
                    $available_gateways = WC()->payment_gateways->payment_gateways();
                    if (!$erplyPaymentMethods = Veebiekspert_Modules()->getErply()->getPaymentMethods()) {
                        $erplyPaymentMethods = [];
                    }
                    if (!$erplyInvoicePaymentMethods = Veebiekspert_Modules()->getErply()->getInvoicePaymentMethods()) {
                        $erplyInvoicePaymentMethods = [];
                    }
                    $erplyPaymentSettings = eliides_arr_get($erplyOptions, ['payment_methods']);
                    $erplyInvoicePaymentSettings = eliides_arr_get($erplyOptions, ['invoice_payment_methods']);
                    $erplyAddPaymentInvoicePaymentSettings = eliides_arr_get($erplyOptions, ['add_payment_payment_methods']);
                    if (!$erplyPaymentMethods) {
                        $erplyPaymentMethods = array();
                    }

                    ?>

                    <table class="widefat fixed" style="margin-top: 20px;">
                        <thead>
                        <tr>
                            <th>E-poe makseviis</th>
                            <th>Erply laekumise konto</th>
                            <th>Erply makseviisi konto</th>
                            <th>Laekumine lisatakse Erplysse</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($available_gateways as $methodName => $method): ?>
                            <tr>
                                <td><?php echo @esc_html($method->title); ?></td>
                                <td>
                                    <select name="veebiekspert_module_erply_options[payment_methods][<?php echo @esc_html($methodName); ?>]">
                                        <option value=""></option>
                                        <?php foreach ($erplyPaymentMethods as $erplyMethod): ?>
                                            <option value="<?php echo $erplyMethod['id']; ?>"<?php if (isset($erplyPaymentSettings[$methodName]) && $erplyMethod['id'] == $erplyPaymentSettings[$methodName]): ?> selected<?php endif; ?>><?php echo @esc_html($erplyMethod['name']); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                                <td>
                                    <select name="veebiekspert_module_erply_options[invoice_payment_methods][<?php echo @esc_html($methodName); ?>]">
                                        <option value=""></option>
                                        <?php foreach ($erplyInvoicePaymentMethods as $erplyMethod): ?>
                                            <option value="<?php echo $erplyMethod['id']; ?>"<?php if (isset($erplyInvoicePaymentSettings[$methodName]) && $erplyMethod['id'] == $erplyInvoicePaymentSettings[$methodName]): ?> selected<?php endif; ?>><?php echo @esc_html($erplyMethod['name']); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                                <td>
                                    <select name="veebiekspert_module_erply_options[add_payment_payment_methods][<?php echo @esc_html($methodName); ?>]">
                                        <option value="yes"<?php if (isset($erplyAddPaymentInvoicePaymentSettings[$methodName]) && $erplyAddPaymentInvoicePaymentSettings[$methodName] == 'yes'): ?> selected<?php endif; ?>>Jah</option>
                                        <option value="no"<?php if (isset($erplyAddPaymentInvoicePaymentSettings[$methodName]) && $erplyAddPaymentInvoicePaymentSettings[$methodName] == 'no'): ?> selected<?php endif; ?>>Ei</option>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>

                    <table class="widefat fixed" style="margin-top: 20px;">
                        <thead>
                        <tr>
                            <th>Tarneviisi ID</th>
                            <th>Nimetus</th>
                            <th>Artikli kood</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($allShippingPackages as $package): ?>
                            <?php
                            if (empty($package->title)) {
                                continue;
                            }
                            $shippingArticle = '';
                            if (isset($erplyOptions['shipping_articles'][$package->id])) {
                                $shippingArticle = $erplyOptions['shipping_articles'][$package->id];
                            }
                            ?>
                            <tr>
                                <td><?php echo $package->id; ?></td>
                                <td><?php echo esc_html($package->title); ?></td>
                                <td>
                                    <input type="text" name="veebiekspert_module_erply_options[shipping_articles][<?php echo $package->id; ?>]" value="<?php echo esc_html($shippingArticle); ?>" />
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>



                <?php else: ?>

                    Aktiveeri Woocommerce moodul, et maksude andmed seadistada

                <?php endif; ?>

            </div>

        </div>

        <?php
    }
}