<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

if ( ! class_exists( 'Veebiekspert_Accouting_Erply' ) ) :


class Veebiekspert_Accouting_Erply {

    /**
     * API
     *
     * @var Veebiekspert_API
     */
    protected $_api;

    protected $_api_key;

    protected $_options = array();

    const SEND_INVOICE = 'eliides_erply_send';

    /**
     * Consturctor
     *
     * @param Veebiekspert_API $api
     */
    public function __construct(Veebiekspert_API $api) {

        $this->_api = $api;
        $this->_api_key = get_option('veebiekspert_module_erply_api_key');

        add_action( 'plugins_loaded', function() {
            if ( class_exists( 'WC_Integration' ) ) {
                include_once( VE_ABS_PATH . 'accounting/erply/erply-integration.php' );
                add_filter( 'woocommerce_integrations', function($integrations) {
                    $integrations[] = 'WC_Integration_Eliides_Erply';
                    return $integrations;
                });
            }
        });

        $veebiekspert_active_module = get_option('veebiekspert_active_module');

        if (!in_array('erply', (array) $veebiekspert_active_module)) {
            return;
        }

        $this->_options = get_option('veebiekspert_module_erply_options');

        add_action('wp_ajax_' . self::SEND_INVOICE, array($this, 'send_invoice_ajax'));

        add_filter( 'eliides_erply_invoice_type', array($this, 'eliides_erply_invoice_type'));
        add_filter( 'eliides_erply_invoice_no', array($this, 'eliides_erply_invoice_no'));
        add_filter( 'eliides_erply_vat_reg_no', array($this, 'eliides_erply_vat_reg_no'));
        add_filter( 'eliides_erply_reg_no', array($this, 'eliides_erply_reg_no'));
        add_filter( 'eliides_erply_invoice_data', array($this, 'eliides_erply_invoice_data'));

        if ($this->_api_key) {

            add_filter('woocommerce_admin_order_actions', array($this, 'show_if_invoice_sent'), 10, 2);
            add_action('admin_footer', array($this, 'custom_bulk_admin_footer'));

            add_action('load-edit.php', array($this, 'bulk_action'));

            $trigger = get_option('veebiekspert_module_erply_trigger');

            //add_action($trigger, array($this, 'send_invoice'));

            add_action('woocommerce_order_status_on-hold', array($this, 'check_if_send_invoice'));
            add_action('woocommerce_order_status_processing', array($this, 'check_if_send_invoice'));
            add_action('woocommerce_order_status_completed', array($this, 'check_if_send_invoice'));

            if (isset($_GET['eliides_sync_erply'])) {
                add_action('init', array($this, 'sync_stock'));
            }
        }

    }

    public function check_if_send_invoice($order_id) {
        $trigger = get_option('veebiekspert_module_erply_trigger');

        if ($order = wc_get_order($order_id)) {

            if ($trigger == 'woocommerce_order_status_on-hold') {

                if ($order->has_status(array('on-hold', 'processing', 'completed'))) {
                    $this->send_invoice($order_id);
                }
            }
            elseif ($trigger == 'woocommerce_order_status_processing') {

                if ($order->has_status(array('processing', 'completed'))) {
                    $this->send_invoice($order_id);
                }
            }
            elseif ($trigger == 'woocommerce_order_status_completed') {

                if ($order->has_status(array('completed'))) {
                    $this->send_invoice($order_id);
                }
            }

        }

    }

    public function eliides_erply_invoice_data($data) {
        return $data;
    }
    public function eliides_erply_invoice_type($type) {
        return $type;
    }

    public function eliides_erply_invoice_no($invoiceNo) {
        return $invoiceNo;
    }

    public function eliides_erply_reg_no($regNo) {
        return $regNo;
    }

    public function eliides_erply_vat_reg_no($regNo) {
        return $regNo;
    }

    public function sync_stock() {
        global $sitepress;

        $outofstockStatus = $this->_options['zero_stock_status'];
        if (empty($outofstockStatus)) {
            $outofstockStatus = 'outofstock';
        }

        $firstImportDone = get_option('eliides_erply_product_first_import_done', 0);
        $lastProductPageNo = get_option('eliides_erply_product_last_page_no', 0);
        $lastProductPageNo ++;

        if ($firstImportDone) {
            $changedSince = get_option('eliides_erply_product_changed_since', strtotime(date('Y-m-d')));
            $products = $this->getProducts([
                'pageNo' => $lastProductPageNo,
                'changedSince' => $changedSince - (3600 * 5),
                'getStockInfo' => 1,
            ]);

            if (!is_array($products)) {
                die('fail');
            }
            if (empty($products)) {
                update_option('eliides_erply_product_last_page_no', 0);
                update_option('eliides_erply_product_changed_since', strtotime(date('Y-m-d H:i')));
            }
            else {
                update_option('eliides_erply_product_last_page_no', $lastProductPageNo);
            }
        }
        else {
            $products = $this->getProducts([
                'pageNo' => $lastProductPageNo,
                'getStockInfo' => 1,
            ]);
            if (!is_array($products)) {
                die('fail');
            }

            if (empty($products)) {
                update_option('eliides_erply_product_first_import_done', 1);
                update_option('eliides_erply_product_last_page_no', 0);
                update_option('eliides_erply_product_changed_since', strtotime(date('Y-m-d H:i')));
            }
            else {
                update_option('eliides_erply_product_last_page_no', $lastProductPageNo);
            }
        }

        foreach ($products as $product) {
            try {
                $qty = 0;

                $ean = $product['code2'];
                $price = $product['price'];

                if (wc_prices_include_tax()) {
                    $price = $product['priceWithVat'];
                }

                if (empty($ean)) {
                    $ean = $product['code'];
                }
                if (empty($ean)) {
                    $ean = $product['supplierCode'];
                }

                if (!empty($this->_options['sku_field'])) {
                    $ean = $product[$this->_options['sku_field']];
                }

                if (empty($ean)) {
                    continue;
                }

                foreach ($product['warehouses'] as $warehouse) {
                    if (!empty($this->_options['warehouse_id'])) {
                        if ((int) $warehouse['warehouseID'] !== (int) $this->_options['warehouse_id']) {
                            continue;
                        }
                    }
                    $qty += $warehouse['totalInStock'] - $warehouse['reserved'];
                }

                if (!empty($ean)) {

                    $productIds = $this->getProductIdsBySku($ean);

                    foreach ($productIds as $productId) {

                        if ($wc_product = wc_get_product($productId)) {

                            foreach ($product['warehouses'] as $warehouse) {
                                update_post_meta($productId, '_erply_warehouse_' . $warehouse['warehouseID'], $warehouse['totalInStock'] - $warehouse['reserved']);
                            }

                            //update_post_meta($productId, '_stock', $qty );
                            $wc_product->set_stock_quantity($qty);

                            if ($qty > 0) {
                                $wc_product->set_stock_status('instock');
                                //update_post_meta( $productId, '_stock_status', 'instock');
                            } else {
                                $wc_product->set_stock_status($outofstockStatus);
                                //update_post_meta( $productId, '_stock_status', $outofstockStatus);
                            }

                            if ($this->_options['allow_price_update'] == 'yes') {

                                if (!empty($price)) {
                                    $wc_product->set_regular_price($price);
                                    //update_post_meta($productId, '_regular_price', $price);

                                    if ($discountPrice = $wc_product->get_sale_price()) {
                                        //update_post_meta($productId, '_price', $discountPrice);
                                        $wc_product->set_sale_price($discountPrice);
                                    } else {
                                        //update_post_meta($productId, '_price', $price);
                                        $wc_product->set_sale_price($price);
                                    }

                                }

                            }

                            $wc_product->save();

                            if ($sitepress) {

                                $trid = $sitepress->get_element_trid($productId, 'post_product');
                                $translations = $sitepress->get_element_translations($trid, 'post_product');

                                foreach ($translations as $trLang => $translation) {
                                    $post_id = $translation->element_id;

                                    if ($wc_product = wc_get_product($post_id)) {

                                        foreach ($product['warehouses'] as $warehouse) {
                                            update_post_meta($post_id, '_erply_warehouse_' . $warehouse['warehouseID'], $warehouse['totalInStock'] - $warehouse['reserved']);
                                        }

                                        $wc_product->set_stock_quantity($qty);

                                        if ($qty > 0) {
                                            $wc_product->set_stock_status('instock');
                                            //update_post_meta( $productId, '_stock_status', 'instock');
                                        } else {
                                            $wc_product->set_stock_status($outofstockStatus);
                                            //update_post_meta( $productId, '_stock_status', $outofstockStatus);
                                        }

                                        if ($this->_options['allow_price_update'] == 'yes') {

                                            if (!empty($price)) {
                                                $wc_product->set_regular_price($price);
                                                //update_post_meta($productId, '_regular_price', $price);

                                                if ($discountPrice = $wc_product->get_sale_price()) {
                                                    //update_post_meta($productId, '_price', $discountPrice);
                                                    $wc_product->set_sale_price($discountPrice);
                                                } else {
                                                    //update_post_meta($productId, '_price', $price);
                                                    $wc_product->set_sale_price($price);
                                                }

                                            }

                                        }

                                        $wc_product->save();

                                    }

                                }
                            }


                        }

                    }
                }
            }
            catch (\Exception $e) {

            }
        }

        if ($firstImportDone) {
            $stockChangedSince = get_option('eliides_erply_product_stock_changed_since', strtotime(date('Y-m-d')));
            $stockPageNo = get_option('eliides_erply_product_stock_page_no', 0);
            $stockPageNo ++;

            $stockParams = [
                'changedSince' => $stockChangedSince,
                'pageNo' => $stockPageNo,
            ];
            if (!empty($this->_options['warehouse_id'])) {
                $stockParams['warehouseID'] = $this->_options['warehouse_id'];
            }
            $products = $this->getStockChangedSince($stockParams);

            update_option('eliides_erply_product_stock_page_no', 0);
            update_option('eliides_erply_product_stock_changed_since', strtotime(date('Y-m-d H:i')));

            foreach ($products as $product) {
                try {
                    $ean = $product['code2'];

                    if (empty($ean)) {
                        $ean = $product['code'];
                    }
                    if (empty($ean)) {
                        $ean = $product['supplierCode'];
                    }

                    if (!empty($this->_options['sku_field'])) {
                        $ean = $product[$this->_options['sku_field']];
                    }

                    if (empty($ean)) {
                        continue;
                    }

                    $qty = $product['free_stock'];

                    if (!empty($ean)) {
                        $productIds = $this->getProductIdsBySku($ean);

                        foreach ($productIds as $productId) {

                            if ($wc_product = wc_get_product($productId)) {
                                $wc_product->set_stock_quantity($qty);

                                foreach ($product['warehouses'] as $warehouse) {
                                    update_post_meta($productId, '_erply_warehouse_' . $warehouse['warehouseID'], $warehouse['totalInStock'] - $warehouse['reserved']);
                                }

                                if ($qty > 0) {
                                    $wc_product->set_stock_status('instock');
                                } else {
                                    $wc_product->set_stock_status($outofstockStatus);
                                }

                                $wc_product->save();

                                if ($sitepress) {

                                    $trid = $sitepress->get_element_trid($productId, 'post_product');
                                    $translations = $sitepress->get_element_translations($trid, 'post_product');

                                    foreach ($translations as $trLang => $translation) {
                                        $post_id = $translation->element_id;

                                        if ($wc_product = wc_get_product($post_id)) {

                                            foreach ($product['warehouses'] as $warehouse) {
                                                update_post_meta($post_id, '_erply_warehouse_' . $warehouse['warehouseID'], $warehouse['totalInStock'] - $warehouse['reserved']);
                                            }

                                            $wc_product->set_stock_quantity($qty);

                                            if ($qty > 0) {
                                                $wc_product->set_stock_status('instock');
                                            } else {
                                                $wc_product->set_stock_status($outofstockStatus);
                                            }

                                            $wc_product->save();

                                        }

                                    }
                                }


                            }

                        }
                    }
                }
                catch (\Exception $e) {

                }
            }
        }
        exit;
    }

    public function bulk_action() {
        $wp_list_table = _get_list_table( 'WP_Posts_List_Table' );
        $action        = $wp_list_table->current_action();

        if ($action !== 'eliide_erply_send_bulk') {
            return false;
        }

        $post_ids = array_map( 'absint', (array) $_REQUEST['post'] );

        foreach ($post_ids as $order_id) {
            $this->send_invoice($order_id);
        }
    }

    public function custom_bulk_admin_footer() {
        global $post_type;
         if($post_type == 'shop_order') {
         ?>
         <script type="text/javascript">
         jQuery(document).ready(function() {
             jQuery('<option>').val('eliide_erply_send_bulk').text('<?php echo esc_html(__('Saada arve Erply serverisse', ELIIDES_TD)); ?>').appendTo('select[name="action"]');
             jQuery('<option>').val('eliide_erply_send_bulk').text('<?php echo esc_html(__('Saada arve Erply serverisse', ELIIDES_TD)); ?>').appendTo('select[name="action2"]');
         });
         </script>
         <?php
         }
    }

    public function send_invoice_ajax() {
        $order_id = absint($_GET['order_id']);

        $this->send_invoice($order_id);

        wp_safe_redirect(wp_get_referer() ? wp_get_referer() : admin_url('edit.php?post_type=shop_order') );
        exit;
    }

    public function show_if_invoice_sent($actions, $order) {

        if (!get_post_meta($order->get_id(), 'erply_invoice_id', true)) {

            //$paymentType = get_post_meta($order->get_id(), '_payment_method', true );
            $paymentType = $order->get_payment_method();

            $disabledPaymentMethods = (array) apply_filters('eliides_accounting_disabled_methods_' . self::SEND_INVOICE, array());

            if (!in_array($paymentType, $disabledPaymentMethods)) {
                $actions[self::SEND_INVOICE] = array(
                    'action' => self::SEND_INVOICE,
                    'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::SEND_INVOICE . '&order_id=' . $order->get_id()), 'eliides-erply-send'),
                    'name' => __('Saada arve Erply serverisse', ELIIDES_TD)
                );
            }
        }
        return $actions;
    }

    public function send_invoice($order_id) {
        $order = wc_get_order($order_id);

        if (get_post_meta($order_id, 'erply_invoice_id', true)) {
            return false;
        }

        //$paymentType = get_post_meta($order_id, '_payment_method', true );
        $paymentType = $order->get_payment_method();

        $disabledPaymentMethods = (array) apply_filters('eliides_accounting_disabled_methods_' . self::SEND_INVOICE, array());

        if (in_array($paymentType, $disabledPaymentMethods)) {
            return false;
        }

        if (!apply_filters('eliides_erply_can_send_order', true, $order)) {
            return false;
        }

        $erplyPaymentSettings = $this->_options['payment_methods'];
        $erplyInvoicePaymentSettings = $this->_options['invoice_payment_methods'];
        $erplyAddPaymentInvoicePaymentSettings = $this->_options['add_payment_payment_methods'];

        //$firstname = $order->get_billing_first_name();
        //$lastname = $order->get_billing_last_name();

        $firstname = $order->get_billing_first_name();
        $lastname = $order->get_billing_last_name();

        $addPayment = 1;

        if (isset($erplyAddPaymentInvoicePaymentSettings[$paymentType]) && $erplyAddPaymentInvoicePaymentSettings[$paymentType] == 'no') {
            $addPayment = 0;
        }


        if (!empty($order->get_shipping_first_name()) && !empty($order->get_shipping_last_name())) {
            $firstname = $order->get_shipping_first_name();
            $lastname = $order->get_shipping_last_name();
        }

        $billTo = $company = trim(implode(' ', array($firstname, $lastname)));

        $isPrivate = 1;

        if ($order->get_billing_company()) {
            $company = $order->get_billing_company();
            $isPrivate = 0;
        }

        $data = array(
            'invoice_no' => apply_filters('eliides_erply_invoice_no', 'WP' . $order->get_order_number(), $order_id),
            'invoice_type' => apply_filters('eliides_erply_invoice_type', 'INVWAYBILL', $order_id),
            'employee_id' => isset($this->_options['employee_id']) ? $this->_options['employee_id'] : '',
            'shop_order_no' => $order->get_order_number(),
            'notes' => $order->get_customer_note(),
            'warehouse_id' => $this->_options['warehouse_id'],
            'date' => $order->get_date_created() ? $order->get_date_created()->date_i18n() : date('Y-m-d'),
            'currency_code' => $order->get_currency(),
            'total' => $order->get_total(),
            'confirm_invoice' => isset($this->_options['confirm_invoice']) ? $this->_options['confirm_invoice'] : 1,
            'payment_type_id' => isset($erplyPaymentSettings[$paymentType]) ? $erplyPaymentSettings[$paymentType] : null,
            'add_payment' => $addPayment,
            'invoice_payment_type_id' => isset($erplyInvoicePaymentSettings[$paymentType]) ? $erplyInvoicePaymentSettings[$paymentType] : null,
            'customer' => array(
                'name' => $company,
                'first_name' => $firstname,
                'last_name' => $lastname,
                'customer_id' => isset($this->_options['customer_id']) ? $this->_options['customer_id'] : '',
                'country_code' => $order->get_billing_country(),
                'is_private' => $isPrivate,
                'address' => implode(' ', array_filter(array($order->get_billing_address_1(), $order->get_billing_address_2()))),
                'city' => $order->get_billing_city(),
                'country' => $order->get_billing_country(),
                'postal_code' => $order->get_billing_postcode(),
                'phone' => $order->get_billing_phone(),
                'email' => $order->get_billing_email(),
                'reg_no' => apply_filters('eliides_erply_reg_no', get_post_meta($order_id, 'company_code', true), $order_id),
                'vat_reg_no' => apply_filters('eliides_erply_vat_reg_no', get_post_meta($order_id, 'company_kmkr', true), $order_id),
            ),
            'rows' => array()
        );

        $erplyTaxSettings = get_option('veebiekspert_module_erply_taxes');

        foreach ($order->get_items( 'line_item' ) as $item_id => $item ) {

            $name = $item->get_name();

            if ($item['variation_id']) {
                $product = wc_get_product($item['variation_id']);
            }
            else {
                $product = wc_get_product($item['product_id']);
            }

            $line_tax_data = isset( $item['line_tax_data'] ) ? $item['line_tax_data'] : '';

            $taxes = $item->get_taxes();
            $sku = null;
            $productId = null;
            if ($product) {
                $sku = $product->get_sku();
                $productId = $product->get_id();
            }

            $tax = 0;
            $tax_item_id = 0;

            $lastTaxId = null;

            $maxTaxSum = 0;
            $maxTaxId = null;

            foreach ($taxes['subtotal'] as $taxId => $taxTotal) {
                $tax_item_id = $taxId;

                if ($maxTaxSum < $taxTotal) {
                    $maxTaxSum = $taxTotal;
                    $maxTaxId = $taxId;
                }

                $lastTaxSum = $taxTotal;
                $lastTaxId = $taxId;
            }

            if (abs($maxTaxSum) > 0) {
                $lastTaxSum = $maxTaxSum;
                $lastTaxId = $maxTaxId;
            }

            $tax_item_id = $lastTaxId;

            if (!isset($erplyTaxSettings[$tax_item_id])) {
                $tax_item_id = 0;
                if (isset($erplyTaxSettings['missing_vat'])) {
                    if (!empty($erplyTaxSettings['missing_vat'])) {
                        $tax_item_id = 'missing_vat';
                    }
                }
            }

            $data['rows'][] = array(
                'product_id' => $productId,
                'tax_id' => $erplyTaxSettings[$tax_item_id],
                'description' => $name,
                'sku' => $sku,
                'sku_field' => $this->_options['sku_field'],
                'quantity' => $item->get_quantity(),
                'price' => $order->get_item_total( $item, false, true ),
                'regular_price' => $product ? wc_get_price_excluding_tax($product, ['price' => $product->get_regular_price()]) : $order->get_item_total( $item, false, true ),
            );

        }

        foreach ($order->get_items( 'fee' ) as $item_id => $item ) {

            $name = $item->get_name();

            $taxes = $item->get_taxes();
            $lastTaxId = null;

            $maxTaxSum = 0;
            $maxTaxId = null;

            foreach ($taxes['subtotal'] as $taxId => $taxTotal) {
                if ($maxTaxSum < $taxTotal) {
                    $maxTaxSum = $taxTotal;
                    $maxTaxId = $taxId;
                }

                $lastTaxId = $taxId;
            }

            if (abs($maxTaxSum) > 0) {
                $lastTaxId = $maxTaxId;
            }

            $tax_item_id = $lastTaxId;

            if (!isset($erplyTaxSettings[$tax_item_id])) {
                $tax_item_id = 0;
                if (isset($erplyTaxSettings['missing_vat'])) {
                    if (!empty($erplyTaxSettings['missing_vat'])) {
                        $tax_item_id = 'missing_vat';
                    }
                }
            }

            $data['rows'][] = array(
                'tax_id' => $erplyTaxSettings[$tax_item_id],
                'description' => $name,
                'sku_field' => $this->_options['sku_field'],
                'quantity' => $item->get_quantity(),
                'price' => $order->get_item_total( $item, false, true ),
            );

        }

        $line_items_shipping = $order->get_items( 'shipping' );

        $shippingArticle = null;

        if ($orderShippingMethods = $order->get_shipping_methods()) {
            $shipping_method = array_shift($orderShippingMethods);
            $shipping_method_id = $shipping_method['method_id'];

            $shippingMethodFullName = $shipping_method_id;
            if ($shipping_method_instance_id = $shipping_method['instance_id']) {
                $shippingMethodFullName .= ':' . $shipping_method_instance_id;
            }

            if (isset($this->_options['shipping_articles'][$shippingMethodFullName])) {
                $shippingArticle = $this->_options['shipping_articles'][$shippingMethodFullName];
            }
        }

        foreach ($line_items_shipping as $item_id => $item) {
            $name = $item->get_name() ? $item->get_name() : __( 'Shipping', 'woocommerce' );
            $tax_data = $item->get_taxes();

            $tax_item_id = 0;
            $lastTaxRow = array();
            $maxValueTaxRow = array();
            $maxTaxValue = 0;

            foreach ($tax_data['total'] as $tax_item_id => $tax_total) {

                if (!isset($erplyTaxSettings[$tax_item_id])) {
                    $tax_item_id = 0;
                    if (isset($erplyTaxSettings['missing_vat'])) {
                        if (!empty($erplyTaxSettings['missing_vat'])) {
                            $tax_item_id = 'missing_vat';
                        }
                    }

                }

                if ($tax_total > $maxTaxValue) {
                    $maxValueTaxRow = array(
                        'tax_id' => $erplyTaxSettings[$tax_item_id],
                        'description' => $name,
                        'quantity' => 1,
                        'sku' => $shippingArticle,
                        'price' => $item->get_total('not-view'),
                    );
                }

                $lastTaxRow = array(
                    'tax_id' => $erplyTaxSettings[$tax_item_id],
                    'description' => $name,
                    'quantity' => 1,
                    'sku' => $shippingArticle,
                    'price' => $item->get_total('not-view'),
                );
            }

            if (!empty($maxValueTaxRow)) {
                $lastTaxRow = $maxValueTaxRow;
            }
            else if (isset($erplyTaxSettings['missing_vat'])) {
                $lastTaxRow = array(
                    'tax_id' => $erplyTaxSettings['missing_vat'],
                    'description' => $name,
                    'quantity' => 1,
                    'sku' => $shippingArticle,
                    'price' => $item->get_total('not-view'),
                );
            }

            $data['rows'][] = $lastTaxRow;
        }

        $data = apply_filters('erply_data_before_send', $data, $order_id);

        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'send-invoice', array(
            'software' => 'erply',
            'software_client_code' => get_option('veebiekspert_module_erply_internal_client_code'),
            'software_username' => get_option('veebiekspert_module_erply_internal_username'),
            'software_password' => get_option('veebiekspert_module_erply_internal_password'),
            'invoice' => apply_filters('eliides_erply_invoice_data', $data, $order_id),
        ));

        if ($res['status'] > 0) {

            $order->add_order_note(sprintf(__('Arve saadeti raamatupidamistarkvarasse %s', ELIIDES_TD), 'Erply'));

            update_post_meta($order_id, 'erply_invoice_id', eliides_sanitize_text_or_array_field($res['data']));

            do_action('eliides_erply_document_created', $order_id, $res['data']);

            return true;
        }
        else {
            //die(print_r($res));
        }
        return false;


    }

    public function getWarehouses() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-warehouses', array(
            'software' => 'erply',
            'software_client_code' => get_option('veebiekspert_module_erply_internal_client_code'),
            'software_username' => get_option('veebiekspert_module_erply_internal_username'),
            'software_password' => get_option('veebiekspert_module_erply_internal_password'),
        ));
        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getInvoicePaymentMethods() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-invoice-payment-methods', array(
            'software' => 'erply',
            'software_client_code' => get_option('veebiekspert_module_erply_internal_client_code'),
            'software_username' => get_option('veebiekspert_module_erply_internal_username'),
            'software_password' => get_option('veebiekspert_module_erply_internal_password'),
        ));
        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getPaymentMethods() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-payment-methods', array(
            'software' => 'erply',
            'software_client_code' => get_option('veebiekspert_module_erply_internal_client_code'),
            'software_username' => get_option('veebiekspert_module_erply_internal_username'),
            'software_password' => get_option('veebiekspert_module_erply_internal_password'),
        ));
        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getTaxes() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-taxes', array(
            'software' => 'erply',
            'software_client_code' => get_option('veebiekspert_module_erply_internal_client_code'),
            'software_username' => get_option('veebiekspert_module_erply_internal_username'),
            'software_password' => get_option('veebiekspert_module_erply_internal_password'),
        ));
        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getProducts($params = []) {
        if (empty($params)) {
            $params = [
                'getStockInfo' => 1,
            ];
        }
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-products', array(
            'software' => 'erply',
            'software_client_code' => get_option('veebiekspert_module_erply_internal_client_code'),
            'software_username' => get_option('veebiekspert_module_erply_internal_username'),
            'software_password' => get_option('veebiekspert_module_erply_internal_password'),
            'params' => $params
        ));

        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getStockChangedSince($params = []) {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-product-stock', array(
            'software' => 'erply',
            'software_client_code' => get_option('veebiekspert_module_erply_internal_client_code'),
            'software_username' => get_option('veebiekspert_module_erply_internal_username'),
            'software_password' => get_option('veebiekspert_module_erply_internal_password'),
            'params' => $params
        ));

        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getProductIdsBySku($sku) {
        if (empty($sku)) {
            return array();
        }
        global $wpdb;

        $sql = $wpdb->prepare("SELECT post_id FROM " . $wpdb->postmeta . " WHERE meta_key = '_sku' AND meta_value = %s", $sku);

        return $wpdb->get_col($sql);
    }

}

endif;
