<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

if ( ! class_exists( 'Veebiekspert_Accouting_Simplbooks' ) ) :


class Veebiekspert_Accouting_Simplbooks {

    /**
     * API
     *
     * @var Veebiekspert_API
     */
    protected $_api;

    protected $_api_key;

    protected $_options = array();

    const SEND_INVOICE = 'eliides_simplbooks_send';

    /**
     * Consturctor
     *
     * @param Veebiekspert_API $api
     */
    public function __construct(Veebiekspert_API $api) {
        $this->_api = $api;
        $this->_api_key = get_option('veebiekspert_module_simplbooks_api_key');

        add_action( 'plugins_loaded', function() {
            if ( class_exists( 'WC_Integration' ) ) {
                include_once( VE_ABS_PATH . 'accounting/simplbooks/simplbooks-integration.php' );
                add_filter( 'woocommerce_integrations', function($integrations) {
                    $integrations[] = 'WC_Integration_Eliides_Simplbooks';
                    return $integrations;
                });
            }
        });

        $veebiekspert_active_module = get_option('veebiekspert_active_module');

        if (!in_array('simplbooks', (array) $veebiekspert_active_module)) {
            return;
        }

        $this->_options = get_option('veebiekspert_module_simplbooks_options');

        add_action('wp_ajax_' . self::SEND_INVOICE, array($this, 'send_invoice_ajax'));

        if ($this->_api_key) {

            add_filter('bulk_actions-woocommerce_page_wc-orders', [$this, 'hpos_bulk_action'], 20, 1);
            add_action('init', array($this, 'do_hpos_bulk_action'));

            add_filter('woocommerce_admin_order_actions', array($this, 'show_if_invoice_sent'), 10, 2);
            add_action('admin_footer', array($this, 'custom_bulk_admin_footer'));

            add_action('load-edit.php', array($this, 'bulk_action'));

            $trigger = get_option('veebiekspert_module_simplbooks_trigger');

            //add_action($trigger, array($this, 'send_invoice'));

            add_action('woocommerce_order_status_on-hold', array($this, 'check_if_send_invoice'));
            add_action('woocommerce_order_status_processing', array($this, 'check_if_send_invoice'));
            add_action('woocommerce_order_status_completed', array($this, 'check_if_send_invoice'));

        }

    }

    public function check_if_send_invoice($order_id) {
        $trigger = get_option('veebiekspert_module_simplbooks_trigger');

        if ($order = wc_get_order($order_id)) {

            if ($trigger == 'woocommerce_order_status_on-hold') {

                if ($order->has_status(array('on-hold', 'processing', 'completed'))) {
                    $this->send_invoice($order_id);
                }
            }
            elseif ($trigger == 'woocommerce_order_status_processing') {

                if ($order->has_status(array('processing', 'completed'))) {
                    $this->send_invoice($order_id);
                }
            }
            elseif ($trigger == 'woocommerce_order_status_completed') {

                if ($order->has_status(array('completed'))) {
                    $this->send_invoice($order_id);
                }
            }

        }

    }

    public function bulk_action() {
        $wp_list_table = _get_list_table( 'WP_Posts_List_Table' );
        $action        = $wp_list_table->current_action();

        if ($action !== 'eliide_simplbooks_send_bulk') {
            return false;
        }

        $post_ids = array_map( 'absint', (array) $_REQUEST['post'] );

        foreach ($post_ids as $order_id) {
            $this->send_invoice($order_id);
        }
    }

    public function do_hpos_bulk_action()
    {
        if (!isset($_REQUEST['action2'])) {
            return;
        }
        if (!in_array($_REQUEST['action2'], ['simplbooks_bulk_send'])) {
            return;
        }
        $post_ids = array_map('intval', (array) $_REQUEST['id']);

        foreach ($post_ids as $order_id) {
            if ($_REQUEST['action2'] == 'simplbooks_bulk_send') {
                $this->send_invoice($order_id);
            }
        }
    }

    public function hpos_bulk_action($actions) {
        $actions['simplbooks_bulk_send'] = __('Saada arve SimplBooks serverisse', ELIIDES_TD);
        return $actions;
    }

    public function custom_bulk_admin_footer() {
        global $post_type;
         if($post_type == 'shop_order') {
         ?>
         <script type="text/javascript">
         jQuery(document).ready(function() {
             jQuery('<option>').val('eliide_simplbooks_send_bulk').text('<?php echo esc_html(__('Saada arve SimplBooks serverisse', ELIIDES_TD)); ?>').appendTo('select[name="action"]');
             jQuery('<option>').val('eliide_simplbooks_send_bulk').text('<?php echo esc_html(__('Saada arve SimplBooks serverisse', ELIIDES_TD)); ?>').appendTo('select[name="action2"]');
         });
         </script>
         <?php
         }
    }

    public function send_invoice_ajax() {
        $order_id = absint($_GET['order_id']);

        $this->send_invoice($order_id);

        wp_safe_redirect(wp_get_referer() ? wp_get_referer() : admin_url('edit.php?post_type=shop_order') );
        exit;
    }

    public function show_if_invoice_sent($actions, $order) {

        if (!$order->get_meta('simplbooks_invoice_id')) {

            $paymentType = $order->get_meta('_payment_method');

            $disabledPaymentMethods = (array) apply_filters('eliides_accounting_disabled_methods_' . self::SEND_INVOICE, array());

            if (!in_array($paymentType, $disabledPaymentMethods)) {
                $actions[self::SEND_INVOICE] = array(
                    'action' => self::SEND_INVOICE,
                    'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::SEND_INVOICE . '&order_id=' . $order->get_id()), 'eliides-simplbooks-send'),
                    'name' => __('Saada arve SimplBooks serverisse', ELIIDES_TD)
                );
            }
        }
        return $actions;
    }

    public function send_invoice($order_id) {
        $order = wc_get_order($order_id);

        if ($order->get_meta('simplbooks_invoice_id')) {
            return false;
        }

        $paymentType = $order->get_meta('_payment_method');

        $disabledPaymentMethods = (array) apply_filters('eliides_accounting_disabled_methods_' . self::SEND_INVOICE, array());

        if (in_array($paymentType, $disabledPaymentMethods)) {
            return false;
        }

        $firstname = $order->get_billing_first_name();
        $lastname = $order->get_billing_last_name();

        if (!empty($order->get_shipping_first_name()) && !empty($order->get_shipping_last_name())) {
            $firstname = $order->get_shipping_first_name();
            $lastname = $order->get_shipping_last_name();
        }

        $billTo = $company = trim(implode(' ', array($firstname, $lastname)));

        $isCompany = 0;

        if ($order->get_billing_company()) {
            $company = $order->get_billing_company();
            $isCompany = 1;
        }

        $data = array(
            'invoice_no' => $order->get_order_number(),
            'date' => $order->get_date_created() ? $order->get_date_created()->date_i18n() : date('Y-m-d'),
            'warehouse_id' => $this->_options['warehouse_id'],
            'is_paid' => false,
            'total' => $order->get_total(),
            'currency_code' => $order->get_currency(),
            'payment_account_id' => null,
            'customer' => array(
                'name' => $company,
                'country_code' => $order->get_billing_country(),
                'is_private' => $isCompany,
                'address' => implode(' ', array_filter(array($order->get_billing_address_1(), $order->get_billing_address_2()))),
                'city' => $order->get_billing_city(),
                'country' => $order->get_billing_country(),
                'postal_code' => $order->get_billing_postcode(),
                'phone' => $order->get_billing_phone(),
                'email' => $order->get_billing_email(),
            ),
            'rows' => array()
        );

        $isDisabledMethod = false;

        if (isset($this->_options['disable_income'][$paymentType]) && $this->_options['disable_income'][$paymentType] == 'no') {
            $isDisabledMethod = true;
        }

        if ($order->is_paid() && $isDisabledMethod == false) {

            $paymentSettings = $this->_options['payment_methods'];

            if (isset($paymentSettings[$paymentType])) {
                $data['is_paid'] = 1;
                $data['payment_account_id'] = $paymentSettings[$paymentType];

            }

        }

        $taxes = WC_Tax::get_rates();

        foreach ($order->get_items( 'line_item' ) as $item_id => $item ) {

            $name = $item->get_name();

            if ($item['variation_id']) {
                $product = wc_get_product($item['variation_id']);
            }
            else {
                $product = wc_get_product($item['product_id']);
            }

            $sku = null;
            if ($product) {
                $sku = $product->get_sku();
            }

            $line_tax_data = isset( $item['line_tax_data'] ) ? $item['line_tax_data'] : '';

            $taxes = $item->get_taxes();

            $tax = 0;
            $tax_item_id = 0;

            foreach ($taxes['subtotal'] as $taxId => $taxTotal) {
                $tax_o = WC_Tax::_get_tax_rate($taxId);
                $tax = $tax_o['tax_rate'];
                break;
            }

            $data['rows'][] = array(
                'sku' => $sku,
                'description' => $name,
                'quantity' => $item->get_quantity(),
                'price' => $order->get_item_total( $item, false, true ),
                'tax_percent' => $tax,
                'row_sum_with_vat' => $order->get_item_total( $item, true, true ),
            );

        }

        $line_items_shipping = $order->get_items( 'shipping' );

        foreach ($line_items_shipping as $item_id => $item) {
            $name = $item->get_name() ? $item->get_name() : __( 'Shipping', 'woocommerce' );
            $tax_data = $item->get_taxes();

            $tax_item_id = 0;
            foreach ($tax_data['total'] as $taxId => $tax_total) {

                $tax_o = WC_Tax::_get_tax_rate($taxId);
                $tax = $tax_o['tax_rate'];

                $data['rows'][] = array(
                    'tax_percent' => $tax,
                    'description' => $name,
                    'quantity' => 1,
                    'price' => $item->get_total('not-view'),
                    'row_sum_with_vat' => $order->get_line_total($item, true, true),
                );

                break;
            }
        }

        $data = apply_filters('simplbooks_data_before_send', $data, $order_id);

        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'send-invoice', array(
            'software' => 'simplbooks',
            'software_company_code' => get_option('veebiekspert_module_simplbooks_internal_client_code'),
            'software_api_key' => get_option('veebiekspert_module_simplbooks_internal_api_key'),
            'invoice' => $data,
        ));

        if ($res['status'] > 0) {

            $order->add_order_note(sprintf(__('Arve saadeti raamatupidamistarkvarasse %s', ELIIDES_TD), 'SimplBooks'));
            $order->update_meta_data('simplbooks_invoice_id', eliides_sanitize_text_or_array_field($res['data']));
            $order->save();
            return true;
        }
        return false;


    }

    public function getWarehouses() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-warehouses', array(
            'software' => 'simplbooks',
            'software_company_code' => get_option('veebiekspert_module_simplbooks_internal_client_code'),
            'software_api_key' => get_option('veebiekspert_module_simplbooks_internal_api_key'),
        ));
        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getPaymentMethods() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-payment-methods', array(
            'software' => 'simplbooks',
            'software_company_code' => get_option('veebiekspert_module_simplbooks_internal_client_code'),
            'software_api_key' => get_option('veebiekspert_module_simplbooks_internal_api_key'),
        ));
        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

}

endif;
