<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

if (!class_exists('Veebiekspert_Accouting_Smartaccounts')):


class Veebiekspert_Accouting_Smartaccounts {

    /**
     * API
     *
     * @var Veebiekspert_API
     */
    protected $_api;

    protected $_api_key;

    protected $_options = array();

    protected $_name = 'smartaccounts';

    const SEND_INVOICE = 'eliides_smartaccounts_send';

    const STOCK_UPDATE_PATCH_META = '_eliides_smartaccounts_stock_patch';

    /**
     * Consturctor
     *
     * @param Veebiekspert_API $api
     */
    public function __construct(Veebiekspert_API $api) {
        $this->_options = get_option('veebiekspert_module_smartaccounts_options');

        $this->_api = $api;
        $this->_api_key = eliides_arr_get($this->_options, 'api_key');

        add_action( 'plugins_loaded', function() {
            if ( class_exists( 'WC_Integration' ) ) {
                include_once( VE_ABS_PATH . 'accounting/smartaccounts/smartaccounts-integration.php' );
                add_filter( 'woocommerce_integrations', function($integrations) {
                    $integrations[] = 'WC_Integration_Eliides_Smartaccounts';
                    return $integrations;
                });
            }
        });

        $veebiekspert_active_module = get_option('veebiekspert_active_module');

        if (!in_array('smartaccounts', (array) $veebiekspert_active_module)) {
            return;
        }



        add_filter( 'woocommerce_email_attachments', array($this, 'woocommerce_email_attachments'), 10, 3 );


        //add_filter('woocommerce_admin_order_actions', array($this, 'add_pdf_invoice_link'), 10, 2);


        add_action('wp_ajax_' . self::SEND_INVOICE, array($this, 'send_invoice_ajax'));

        if ($this->_api_key) {
            add_filter('bulk_actions-woocommerce_page_wc-orders', [$this, 'hpos_bulk_action'], 20, 1);
            add_action('init', array($this, 'do_hpos_bulk_action'));
            add_filter('woocommerce_admin_order_actions', array($this, 'show_if_invoice_sent'), 10, 2);
            add_action('admin_footer', array($this, 'custom_bulk_admin_footer'));

            add_action('load-edit.php', array($this, 'bulk_action'));

            add_action('woocommerce_order_status_on-hold', array($this, 'check_if_send_invoice'));
            add_action('woocommerce_order_status_processing', array($this, 'check_if_send_invoice'));
            add_action('woocommerce_order_status_completed', array($this, 'check_if_send_invoice'));

            if (isset($_GET['eliides_sync_smartaccounts'])) {
                add_action('init', array($this, 'sync_stock'));
            }

        }

    }

    public function sync_stock()
    {
        global $wpdb;

        $outofstockStatus = eliides_arr_get($this->_options, ['zero_stock_status']);
        if (empty($outofstockStatus)) {
            $outofstockStatus = 'outofstock';
        }

        $lastPatch = (int) get_option(self::STOCK_UPDATE_PATCH_META, 1);

        $posts = get_posts(array(
            'posts_per_page' => 50,
            'post_type' => ['product', 'product_variation'],
            'meta_query' => array(
                'relation' => 'OR',
                array(
                    'key' => self::STOCK_UPDATE_PATCH_META,
                    'value' => $lastPatch,
                    'compare' => '!='
                ),
                array(
                    'key' => self::STOCK_UPDATE_PATCH_META,
                    'compare' => 'NOT EXISTS'
                ),
            )
        ));

        $productIdsBySku = [];

        foreach ($posts as $post) {
            if ($sku = get_post_meta($post->ID, '_sku', true)) {
                $rows = $wpdb->get_results($wpdb->prepare("
                    SELECT post_id FROM {$wpdb->postmeta} WHERE meta_key = '_sku' AND meta_value = %s
                ", $sku), ARRAY_A);

                foreach ($rows as $row) {
                    if (!isset($productIdsBySku[$sku])) {
                        $productIdsBySku[$sku] = [];
                    }
                    $productIdsBySku[$sku][] = $row['post_id'];
                }
            }
            update_post_meta($post->ID, self::STOCK_UPDATE_PATCH_META, $lastPatch);
        }

        if (!empty($productIdsBySku)) {

            $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-product-stock', array(
                'software' => 'smartaccounts',
                'codes' => array_keys($productIdsBySku),
                'software_api_id' => eliides_arr_get($this->_options, 'api_key'),
                'software_public_key' => eliides_arr_get($this->_options, 'public_key'),
                'software_private_key' => eliides_arr_get($this->_options, 'private_key'),
            ));

            if ($res['status'] > 0) {
                foreach (eliides_arr_get($res, 'data', []) as $stockItem) {
                    if ($stockItem['status'] !== 'OK') {
                        continue;
                    }
                    foreach ($productIdsBySku[$stockItem['code']] as $postId) {
                        if ($wc_product = wc_get_product($postId)) {
                            $wc_product->set_stock_quantity($stockItem['qty']);

                            if ($stockItem['qty'] > 0) {
                                $wc_product->set_stock_status('instock');
                            } else {
                                $wc_product->set_stock_status($outofstockStatus);
                            }

                            $wc_product->save();
                        }
                    }
                }
            }

        }

        if (empty($posts) || count($posts) < 50) {
            $lastPatch ++;
            update_option(self::STOCK_UPDATE_PATCH_META, $lastPatch);
        }

        die('done');
    }

    public function woocommerce_email_attachments ( $attachments , $email_id, $order  ) {
        if ( ! is_a( $order, 'WC_Order' ) || ! isset( $email_id ) ) {
            return $attachments;
        }

        if (eliides_arr_get($this->_options, 'send_smartaccounts_pdf') !== 'yes') {
            return $attachments;
        }

        if( $email_id === 'customer_completed_order' ){
            if ($base64Pdf = $this->getInvoicePDF($order->get_id())) {

                $dest = VE_ABS_PATH . 'tmp/';
                if (!file_exists($dest)) {
                    mkdir($dest);
                }
                $dest .= 'smartaccounts/';
                if (!file_exists($dest)) {
                    mkdir($dest);
                }

                $dest .= $order->get_id() . '_arve.pdf';


                file_put_contents($dest, base64_decode($base64Pdf));

                $attachments[] = $dest;
            }
        }

        return $attachments;
    }

    public function check_if_send_invoice($order_id) {
        $trigger = eliides_arr_get($this->_options, 'invoice_trigger');

        if ($order = wc_get_order($order_id)) {

            if ($trigger == 'woocommerce_order_status_on-hold') {

                if ($order->has_status(array('on-hold', 'processing', 'completed'))) {
                    $this->send_invoice($order_id);
                }
            }
            elseif ($trigger == 'woocommerce_order_status_processing') {

                if ($order->has_status(array('processing', 'completed'))) {
                    $this->send_invoice($order_id);
                }
            }
            elseif ($trigger == 'woocommerce_order_status_completed') {

                if ($order->has_status(array('completed'))) {
                    $this->send_invoice($order_id);
                }
            }

        }

    }

    public function do_hpos_bulk_action()
    {
        if (!isset($_REQUEST['action2'])) {
            return;
        }
        if (!in_array($_REQUEST['action2'], ['smartaccounts_bulk_send', 'smartaccounts_bulk_delete'])) {
            return;
        }
        $post_ids = array_map('intval', (array) $_REQUEST['id']);

        foreach ($post_ids as $order_id) {
            if ($_REQUEST['action2'] == 'smartaccounts_bulk_send') {
                $this->send_invoice($order_id);
            }

            if ($_REQUEST['action2'] == 'smartaccounts_bulk_delete') {
                $this->delete_invoice($order_id);
            }
        }
    }

    public function hpos_bulk_action($actions) {
        $actions['smartaccounts_bulk_send'] = __('Saada arve SmartAccountsi serverisse', ELIIDES_TD);
        $actions['smartaccounts_bulk_delete'] = __('Kustuta arve SmartAccountsist', ELIIDES_TD);
        return $actions;
    }

    public function bulk_action() {
        $wp_list_table = _get_list_table( 'WP_Posts_List_Table' );
        $action        = $wp_list_table->current_action();

        if ($action !== 'eliide_smartaccounts_send_bulk' && $action !== 'eliides_smartaccounts_delete_bulk') {
            return false;
        }

        $post_ids = array_map( 'absint', (array) $_REQUEST['post'] );

        foreach ($post_ids as $order_id) {
            if ($action == 'eliide_smartaccounts_send_bulk') {
                $this->send_invoice($order_id);
            }

            if ($action == 'eliides_smartaccounts_delete_bulk') {
                $this->delete_invoice($order_id);
            }
        }
    }

    public function custom_bulk_admin_footer() {
        global $post_type;
         if($post_type == 'shop_order') {
         ?>
         <script type="text/javascript">
         jQuery(document).ready(function() {
             jQuery('<option>').val('eliide_smartaccounts_send_bulk').text('<?php echo esc_html(__('Saada arve SmartAccountsi serverisse', ELIIDES_TD)); ?>').appendTo('select[name="action"]');
             jQuery('<option>').val('eliides_smartaccounts_delete_bulk').text('<?php echo esc_html(__('Kustuta arve SmartAccountsist', ELIIDES_TD)); ?>').appendTo('select[name="action"]');
             jQuery('<option>').val('eliide_smartaccounts_send_bulk').text('<?php echo esc_html(__('Saada arve SmartAccountsi serverisse', ELIIDES_TD)); ?>').appendTo('select[name="action2"]');
             jQuery('<option>').val('eliides_smartaccounts_delete_bulk').text('<?php echo esc_html(__('Kustuta arve SmartAccountsist', ELIIDES_TD)); ?>').appendTo('select[name="action2"]');
         });
         </script>
         <?php
         }
    }

    public function send_invoice_ajax() {
        $order_id = absint($_GET['order_id']);

        $this->send_invoice($order_id);

        wp_safe_redirect(wp_get_referer() ? wp_get_referer() : admin_url('edit.php?post_type=shop_order') );
        exit;
    }

    public function show_if_invoice_sent($actions, $order) {

        if (!$order->get_meta('smartaccount_invoice')) {

            $paymentType = $order->get_payment_method();

            $disabledPaymentMethods = (array) apply_filters('eliides_accounting_disabled_methods_' . self::SEND_INVOICE, array());

            if (!in_array($paymentType, $disabledPaymentMethods)) {
                $actions[self::SEND_INVOICE] = array(
                    'action' => self::SEND_INVOICE,
                    'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::SEND_INVOICE . '&order_id=' . $order->get_id()), 'eliides-merit-send'),
                    'name' => __('Saada arve SmartAccountsi serverisse', ELIIDES_TD)
                );
            }

        }
        return $actions;
    }

    public function delete_invoice($order_id) {
        $order = wc_get_order($order_id);
        if (!$invoiceData = $order->get_meta('smartaccount_invoice')) {
            return false;
        }

        $documentType = 'invoice';
        $documentId = eliides_arr_get($invoiceData, 'invoiceId');

        if (isset($invoiceData['orderId'])) {
            $documentType = 'order';
            $documentId = eliides_arr_get($invoiceData, 'orderId');
        }

        if (isset($invoiceData['offerId'])) {
            $documentType = 'offer';
            $documentId = eliides_arr_get($invoiceData, 'offerId');
        }

        if (!empty($documentId)) {
            $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'delete-invoice', array(
                'software' => 'smartaccounts',
                'software_api_id' => eliides_arr_get($this->_options, 'api_key'),
                'software_public_key' => eliides_arr_get($this->_options, 'public_key'),
                'software_private_key' => eliides_arr_get($this->_options, 'private_key'),
                'invoice_id' => $documentId,
                'document_type' => $documentType,
            ));

            if ($res['status'] > 0) {
                $order->delete_meta_data('smartaccount_invoice');
                $order->save();
            }
        }
    }

    public function send_invoice($order_id) {
        $order = wc_get_order($order_id);

        do_action('before_smartaccounts_send_invoice_process', $order);

        $paymentType = $order->get_payment_method();

        if ($order->get_meta('smartaccount_invoice')) {
            return false;
        }

        $disabledPaymentMethods = (array) apply_filters('eliides_accounting_disabled_methods_' . self::SEND_INVOICE, array());

        if (in_array($paymentType, $disabledPaymentMethods)) {
            return false;
        }

        $hasEUVat = false;

        if ($vatNr = $order->get_meta('_vat_number')) {
            $hasEUVat = true;
        }
        if ($vatCompanyAc = $order->get_meta('company_kmkr')) {
            $vatNr = $vatCompanyAc;
        }
        if ($vatBillingAc = $order->get_meta('_billing_eu_vat_number')) {
            $hasEUVat = true;
            if (is_array($vatBillingAc)) {
                $vatNr = array_shift($vatBillingAc);
            }
            else {
                $vatNr = $vatBillingAc;
            }
        }
        if ($vatBillingAc = $order->get_meta('_billing_vat')) {
            $hasEUVat = true;
        }

        $firstname = $order->get_billing_first_name();
        $lastname = $order->get_billing_last_name();

        $billTo = $company = trim(implode(' ', array($firstname, $lastname)));

        $isCompany = 0;

        if ($order->get_billing_company()) {
            $company = $order->get_billing_company();
            $isCompany = 1;
        }

        $footerComment = array();
        $headerComment = array();

        $countryCode = strtoupper(empty($order->get_billing_country()) ? 'EE' : $order->get_billing_country());

        $invoiceNr = eliides_arr_get($this->_options, ['invoice_prefix'], 'WP') . $order->get_order_number();

        if (function_exists('wcpdf_get_invoice')) {
            if ( $invoice = wcpdf_get_invoice( $order ) ) {
                $wcpdfInvoiceNr = (string) $invoice->get_number();
                if (!empty($wcpdfInvoiceNr)) {
                    $invoiceNr = $wcpdfInvoiceNr;
                }
            }
        }

        $data = array(
            'invoice_no' => apply_filters('eliides_smartaccounts_invoice_no', $invoiceNr, $order_id),
            'document_type' => eliides_arr_get($this->_options, 'document_type', 'invoice'),
            'date' => $order->get_date_created() ? $order->get_date_created()->date_i18n() : date('Y-m-d'),
            'currency_code' => $order->get_currency(),
            'footer_commment' => '',
            'header_commment' => '',
            'total' => $order->get_total(),
            'customer' => array(
                'name' => $company,
                'country_code' => empty($countryCode) ? 'EE' : $countryCode,
                'is_private' => $isCompany,
                'address' => implode(' ', array_filter(array($order->get_billing_address_1(), $order->get_billing_address_2()))),
                'city' => $order->get_billing_city(),
                'country' => $order->get_billing_country(),
                'postal_code' => $order->get_billing_postcode(),
                'phone' => $order->get_billing_phone(),
                'email' => $order->get_billing_email(),
                'vat_reg_no' => $vatNr,
                'reg_no' => $order->get_meta('company_code'),
            ),
            'rows' => array()
        );

        if (eliides_arr_get($this->_options, 'object')) {
            $data['object'] = eliides_arr_get($this->_options, 'object');
        }

        if (eliides_arr_get($this->_options, 'warehouse')) {
            $data['warehouse_id'] = eliides_arr_get($this->_options, 'warehouse');
        }

        $isDisabledMethod = false;

        if (isset($this->_options['disable_income'][$paymentType]) && $this->_options['disable_income'][$paymentType] == 'no') {
            $isDisabledMethod = true;
        }

        $smartAccountPaymentSettings = eliides_arr_get($this->_options, ['payment_methods'], []);
        if (isset($smartAccountPaymentSettings[$paymentType])) {
            $data['payment_type_id'] = $smartAccountPaymentSettings[$paymentType];
            if ($order->is_paid() && $isDisabledMethod == false) {
                $data['add_payment'] = 1;
            }
        }

        $smartAccountTaxSettings = eliides_arr_get($this->_options, 'taxes', []);
        $smartAccountTaxAccountSettings = eliides_arr_get($this->_options, 'tax_accounts', []);

        foreach ($order->get_items( 'line_item' ) as $item_id => $item ) {

            $name = $item->get_name();

            if ($item['variation_id']) {
                $product = wc_get_product($item['variation_id']);
            }
            else {
                $product = wc_get_product($item['product_id']);
            }
            $sku = null;
            $productId = null;
            if ($product) {
                $productId = $product->get_id();
                $sku = $product->get_sku();
            }

            $line_tax_data = isset( $item['line_tax_data'] ) ? $item['line_tax_data'] : '';
            $tax_data = maybe_unserialize( $line_tax_data );

            $taxes = $item->get_taxes();

            $tax_item_id = 0;

            $lastTaxSum = 0;
            $lastTaxId = null;

            $maxTaxSum = 0;
            $maxTaxId = null;

            foreach ($taxes['subtotal'] as $taxId => $taxTotal) {
                $tax_item_id = $taxId;

                if ($maxTaxSum < $taxTotal) {
                    $maxTaxSum = $taxTotal;
                    $maxTaxId = $taxId;
                }

                $lastTaxSum = $taxTotal;
                $lastTaxId = $taxId;
            }

            if (abs($maxTaxSum) > 0) {
                $lastTaxSum = $maxTaxSum;
                $lastTaxId = $maxTaxId;
            }

            $tax_item_id = $lastTaxId;

            if (!isset($smartAccountTaxSettings[$tax_item_id])) {
                $tax_item_id = 0;
                if (isset($smartAccountTaxSettings['missing_vat'])) {
                    if (strlen($smartAccountTaxSettings['missing_vat']) > 0) {
                        $tax_item_id = 'missing_vat';
                    }
                }

            }

            $discount = '';

            if ($item->get_subtotal() !== $item->get_total()) {
                $discount = number_format($item->get_subtotal() - $item->get_total(), 2, '.', '');
            }

            $data['rows'][] = array(
                'product_id' => $productId,
                'tax_id' => $smartAccountTaxSettings[$tax_item_id],
                'tax_account_id' => eliides_arr_get($smartAccountTaxAccountSettings, [$tax_item_id], null),
                'description' => $name,
                'code' => $sku,
                'quantity' => $item->get_quantity(),
                'price' => $order->get_item_total( $item, false, false ),
                'discount_sum' => $discount,
                'row_type' => 'line_item',
                'type' => eliides_arr_get($this->_options, ['invoice_row_type'], 'PRODUCT'),
            );

        }

        foreach ($order->get_items( 'fee' ) as $item_id => $item ) {

            $name = $item->get_name();

            $line_tax_data = isset( $item['line_tax_data'] ) ? $item['line_tax_data'] : '';
            $tax_data = maybe_unserialize( $line_tax_data );

            $taxes = $item->get_taxes();

            $tax_item_id = 0;

            $lastTaxSum = 0;
            $lastTaxId = null;

            $maxTaxSum = 0;
            $maxTaxId = null;

            foreach ($taxes['total'] as $taxId => $taxTotal) {
                $tax_item_id = $taxId;

                if ($maxTaxSum < $taxTotal) {
                    $maxTaxSum = $taxTotal;
                    $maxTaxId = $taxId;
                }

                $lastTaxSum = $taxTotal;
                $lastTaxId = $taxId;
            }

            if (abs($maxTaxSum) > 0) {
                $lastTaxSum = $maxTaxSum;
                $lastTaxId = $maxTaxId;
            }

            $tax_item_id = $lastTaxId;

            if (!isset($smartAccountTaxSettings[$tax_item_id])) {
                $tax_item_id = 0;
                if (isset($smartAccountTaxSettings['missing_vat'])) {
                    if (strlen($smartAccountTaxSettings['missing_vat']) > 0) {
                        $tax_item_id = 'missing_vat';
                    }
                }

            }

            $discount = '';

            $data['rows'][] = array(
                'tax_id' => $smartAccountTaxSettings[$tax_item_id],
                'tax_account_id' => eliides_arr_get($smartAccountTaxAccountSettings, [$tax_item_id], null),
                'description' => $name,
                'code' => '',
                'quantity' => $item->get_quantity(),
                'price' => $order->get_item_total( $item, false, false ),
                'discount_sum' => $discount,
                'row_type' => 'fee',
                'type' => 'SERVICE',
            );

        }

        $line_items_shipping = $order->get_items( 'shipping' );

        $shippingArticle = null;

        if ($orderShippingMethods = $order->get_shipping_methods()) {
            $shipping_method = array_shift($orderShippingMethods);
            $shipping_method_id = $shipping_method['method_id'];

            $shippingMethodFullName = $shipping_method_id;
            if ($shipping_method_instance_id = $shipping_method['instance_id']) {
                $shippingMethodFullName .= ':' . $shipping_method_instance_id;
            }

            if (isset($this->_options['shipping_articles'][$shippingMethodFullName])) {
                $shippingArticle = $this->_options['shipping_articles'][$shippingMethodFullName];
            }
        }

        foreach ($line_items_shipping as $item_id => $item) {
            $name = $item->get_name() ? $item->get_name() : __( 'Shipping', 'woocommerce' );
            $tax_data = $item->get_taxes();

            if (empty(eliides_arr_get($tax_data, ['total']))) {
                $footerComment[] = 'Tarneviis: ' . $name;
            }

            $tax_item_id = 0;

            $lastTaxRow = array();
            $maxValueTaxRow = array();
            $maxTaxValue = 0;

            if (empty($tax_data['total'])) {
                if (isset($smartAccountTaxSettings['missing_vat']) && strlen($smartAccountTaxSettings['missing_vat']) > 0) {
                    $lastTaxRow = array(
                        'tax_id' => $smartAccountTaxSettings['missing_vat'],
                        'tax_account_id' => eliides_arr_get($smartAccountTaxAccountSettings, ['missing_vat'], null),
                        'description' => $name,
                        'code' => $shippingArticle,
                        'quantity' => 1,
                        'price' => $order->get_item_total( $item, false, false ),
                    );
                    $maxValueTaxRow = $lastTaxRow;
                }

            }
            else {
                foreach ($tax_data['total'] as $tax_item_id => $tax_total) {
                    if (!isset($smartAccountTaxSettings[$tax_item_id])) {
                        $tax_item_id = 0;
                        if (isset($smartAccountTaxSettings['missing_vat'])) {
                            if (strlen($smartAccountTaxSettings['missing_vat']) > 0) {
                                $tax_item_id = 'missing_vat';
                            }
                        }

                    }

                    if ($tax_total > $maxTaxValue) {
                        $maxValueTaxRow = array(
                            'tax_id' => $smartAccountTaxSettings[$tax_item_id],
                            'tax_account_id' => eliides_arr_get($smartAccountTaxAccountSettings, [$tax_item_id], null),
                            'description' => $name,
                            'code' => $shippingArticle,
                            'quantity' => 1,
                            'price' => $order->get_item_total( $item, false, false ),
                        );
                    }

                    $lastTaxRow = array(
                        'tax_id' => $smartAccountTaxSettings[$tax_item_id],
                        'tax_account_id' => eliides_arr_get($smartAccountTaxAccountSettings, [$tax_item_id], null),
                        'description' => $name,
                        'code' => $shippingArticle,
                        'quantity' => 1,
                        'price' => $order->get_item_total( $item, false, false ),
                    );

                }
            }



            if (!empty($maxValueTaxRow)) {
                $lastTaxRow = $maxValueTaxRow;
            }
            $lastTaxRow['row_type'] = 'shipping';
            $lastTaxRow['type'] = 'SERVICE';
            $data['rows'][] = $lastTaxRow;
        }

        if (!empty($footerComment)) {
            $data['footer_comment'] = implode(', ', $footerComment);
        }

        if (!empty($headerComment)) {
            $data['header_comment'] = implode(', ', $headerComment);
        }

        if ($hasEUVat) {
            foreach ($data['rows'] as $rowK => $row) {
                if (isset($smartAccountTaxSettings['eu_vat_code'])) {
                    if (strlen($smartAccountTaxSettings['eu_vat_code']) > 0) {
                        $data['rows'][$rowK]['tax_id'] = $smartAccountTaxSettings['eu_vat_code'];
                    }
                }
                if (isset($smartAccountTaxAccountSettings['eu_vat_code'])) {
                    if (strlen($smartAccountTaxAccountSettings['eu_vat_code']) > 0) {
                        $data['rows'][$rowK]['tax_account_id'] = $smartAccountTaxAccountSettings['eu_vat_code'];
                    }
                }
            }
        }

        $data = apply_filters('smartaccounts_data_before_send', $data, $order_id);

        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'send-invoice', array(
            'software' => 'smartaccounts',
            'software_api_id' => eliides_arr_get($this->_options, 'api_key'),
            'software_public_key' => eliides_arr_get($this->_options, 'public_key'),
            'software_private_key' => eliides_arr_get($this->_options, 'private_key'),
            'invoice' => $data,
        ));

        if (eliides_arr_get($res, 'status') > 0) {
            $order->add_order_note(sprintf(__('Arve saadeti raamatupidamistarkvarasse %s', ELIIDES_TD), 'SmartAccounts'));
            $order->update_meta_data('smartaccount_invoice', eliides_sanitize_text_or_array_field($res['data']));
            $order->save();
            return true;
        }
        return false;


    }

    public function createCustomer($data) {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-customer', array(
            'software' => 'smartaccounts',
            'software_api_id' => eliides_arr_get($this->_options, 'api_key'),
            'software_public_key' => eliides_arr_get($this->_options, 'public_key'),
            'software_private_key' => eliides_arr_get($this->_options, 'private_key'),
            'customer' => $data,
        ));

        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getTaxes() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-taxes', array(
            'software' => 'smartaccounts',
            'software_api_id' => eliides_arr_get($this->_options, 'api_key'),
            'software_public_key' => eliides_arr_get($this->_options, 'public_key'),
            'software_private_key' => eliides_arr_get($this->_options, 'private_key'),
        ));

        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getPaymentMethods() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-payment-methods', array(
            'software' => 'smartaccounts',
            'software_api_id' => eliides_arr_get($this->_options, 'api_key'),
            'software_public_key' => eliides_arr_get($this->_options, 'public_key'),
            'software_private_key' => eliides_arr_get($this->_options, 'private_key'),
        ));

        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getObjects() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-objects', array(
            'software' => 'smartaccounts',
            'software_api_id' => eliides_arr_get($this->_options, 'api_key'),
            'software_public_key' => eliides_arr_get($this->_options, 'public_key'),
            'software_private_key' => eliides_arr_get($this->_options, 'private_key'),
        ));

        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getAccounts() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-tax-accounts', array(
            'software' => 'smartaccounts',
            'software_api_id' => eliides_arr_get($this->_options, 'api_key'),
            'software_public_key' => eliides_arr_get($this->_options, 'public_key'),
            'software_private_key' => eliides_arr_get($this->_options, 'private_key'),
        ));

        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getWarehouses() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-warehouses', array(
            'software' => 'smartaccounts',
            'software_api_id' => eliides_arr_get($this->_options, 'api_key'),
            'software_public_key' => eliides_arr_get($this->_options, 'public_key'),
            'software_private_key' => eliides_arr_get($this->_options, 'private_key'),
        ));

        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getInvoicePDF($order_id) {
        $order = wc_get_order($order_id);
        if (!$invoiceData = $order->get_meta('smartaccount_invoice')) {
            return false;
        }

        if (isset($invoiceData['invoiceId']) && !empty($invoiceData['invoiceId'])) {
            $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-invoice-pdf', array(
                'software' => 'smartaccounts',
                'software_api_id' => eliides_arr_get($this->_options, 'api_key'),
                'software_public_key' => eliides_arr_get($this->_options, 'public_key'),
                'software_private_key' => eliides_arr_get($this->_options, 'private_key'),
                'invoice_id' => $invoiceData['invoiceId'],
            ));

            if ($res['status'] > 0) {
                return eliides_arr_get($res, 'pdf');
            }
        }

        return false;
    }

}

endif;
