<?php

class WC_Integration_Eliides_CompanyAutocomplete extends WC_Integration {


    public function __construct() {
        $this->id                 = 'company_autocomplete';
        $this->method_title       = 'Äriregistri liides';
        $this->method_description = null;

        $this->init_form_fields();
        $this->init_settings();

        add_action( 'woocommerce_update_options_integration_' .  $this->id, array( $this, 'process_admin_options' ) );
    }

    public function process_admin_options()
    {
        $this->init_settings();

        $post_data = $this->get_post_data();
        update_option('veebiekspert_module_company_autocomplete_api_key', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_company_autocomplete_api_key']));
        update_option('veebiekspert_module_company_autocomplete_params', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_company_autocomplete_params']));

        $activeModules = (array) get_option('veebiekspert_active_module', []);
        $module = 'company_autocomplete';

        if (!empty($post_data['is_module_active'])) {
            if (!in_array($module, $activeModules)) {
                $activeModules[] = $module;
                update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
            }
        }
        else {
            $key = array_search($module, $activeModules);
            if (false !== $key) {
                unset($activeModules[$key]);
                update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
            }
        }

    }

    public function admin_options() {
        parent::admin_options();

        $veebiekspert_active_module = (array) get_option('veebiekspert_active_module');
        ?>
        <div class="veebiekspert-setting-block">

            <input type="hidden" name="is_module_active" value="0" />
            <h2><label><input type="checkbox" name="is_module_active"<?php if (in_array('company_autocomplete', $veebiekspert_active_module)): ?> checked<?php endif; ?> value="1" /> Aktiivne</label></h2>

            <div class="settings-block-inner">

                <div class="ve-form-group">
                    <label>E-liides litsentsi võti</label>
                    <input type="text" id="veebiekspert_module_company_autocomplete_api_key" name="veebiekspert_module_company_autocomplete_api_key" value="<?php echo get_option('veebiekspert_module_company_autocomplete_api_key'); ?>" />
                    <a href="https://www.e-liides.ee" target="_blank">Registreeri võti (7 päeva tasuta)</a>
                </div>
            </div>

        </div>

        <?php
    }
}