<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

class Veebiekspert_Custom_CompanyAutocomplete {

    /**
     * API
     *
     * @var Veebiekspert_API
     */
    protected $_api;

    protected $_api_key;

    protected $_options = array();

    protected $_name = 'company_autocomplete';

    /**
     * Consturctor
     *
     * @param Veebiekspert_API $api
     */
    public function __construct(Veebiekspert_API $api) {

        $this->_api = $api;

        $veebiekspert_active_module = get_option('veebiekspert_active_module');

        add_action( 'plugins_loaded', function() {
            if ( class_exists( 'WC_Integration' ) ) {
                include_once( VE_ABS_PATH . 'custom/company_autocomplete-integration.php' );
                add_filter( 'woocommerce_integrations', function($integrations) {
                    $integrations[] = 'WC_Integration_Eliides_CompanyAutocomplete';
                    return $integrations;
                });
            }
        });

        if (!in_array('company_autocomplete', (array) $veebiekspert_active_module)) {
            return;
        }

        $this->_api_key = get_option('veebiekspert_module_company_autocomplete_api_key');
        $this->_options = get_option('veebiekspert_module_company_autocomplete_params');



        if ($this->_api_key) {
            add_action( 'wp_enqueue_scripts', array($this, 'enqueue_scripts') );
            add_action('wp_ajax_eliides_ac_company', array($this, 'get_companies'));
            add_action('wp_ajax_nopriv_eliides_ac_company', array($this, 'get_companies'));

            add_action( 'woocommerce_after_checkout_validation', array($this, 'woocommerce_after_checkout_validation'), 10, 2 );

            add_filter('woocommerce_billing_fields', array($this, 'woocommerce_billing_fields'));
            add_filter('woocommerce_shipping_fields', array($this, 'woocommerce_shipping_fields'));

            add_action('wp_footer', array($this, 'woocommerce_after_checkout_billing_form'));

            add_filter( 'woocommerce_admin_billing_fields' , array($this, 'woocommerce_admin_billing_fields') );
            add_filter( 'woocommerce_admin_shipping_fields' , array($this, 'woocommerce_admin_shipping_fields') );

            add_action( 'woocommerce_checkout_update_order_meta', array($this, 'woocommerce_checkout_update_order_meta') );
        }

    }

    public function woocommerce_checkout_update_order_meta($orderId) {
        if ( ! empty( $_POST['company_code'] ) ) {
            update_post_meta( $orderId, 'company_code', sanitize_text_field( $_POST['company_code'] ) );
        }
        if ( ! empty( $_POST['company_kmkr'] ) ) {
            update_post_meta( $orderId, 'company_kmkr', sanitize_text_field( $_POST['company_kmkr'] ) );
        }
        if ( ! empty( $_POST['shipping_company_code'] ) ) {
            update_post_meta( $orderId, 'shipping_company_code', sanitize_text_field( $_POST['shipping_company_code'] ) );
        }
        if ( ! empty( $_POST['shipping_company_kmkr'] ) ) {
            update_post_meta( $orderId, 'shipping_company_kmkr', sanitize_text_field( $_POST['shipping_company_kmkr'] ) );
        }
    }

    public function woocommerce_admin_billing_fields($fields) {
        global $post;

        $fields['company_code'] = array(
            'label' => __('Reg nr', ELIIDES_TD),
            'show'  => true,
            'wrapper_class' => 'form-field-wide',
            'style' => '',
            'value' => get_post_meta($post->ID, 'company_code', true),
        );

        $fields['company_kmkr'] = array(
            'label' => __('KMKR nr.', ELIIDES_TD),
            'show'  => true,
            'wrapper_class' => 'form-field-wide',
            'style' => '',
            'value' => get_post_meta($post->ID, 'company_kmkr', true),
        );

        return $fields;
    }

    public function woocommerce_admin_shipping_fields($fields) {
        global $post;

        $fields['company_code'] = array(
            'label' => __('Reg nr', ELIIDES_TD),
            'show'  => true,
            'wrapper_class' => 'form-field-wide',
            'style' => '',
            'value' => get_post_meta($post->ID, 'shipping_company_code', true),
        );

        $fields['company_kmkr'] = array(
            'label' => __('KMKR nr.', ELIIDES_TD),
            'show'  => true,
            'wrapper_class' => 'form-field-wide',
            'style' => '',
            'value' => get_post_meta($post->ID, 'shipping_company_kmkr', true),
        );

        return $fields;
    }

    public function woocommerce_after_checkout_validation( $data, $errors ) {
        if (!empty($data['billing_company']) && strtolower($data['billing_country']) == 'ee') {
            if (empty($data['company_code']) && empty($data['shipping_company_code'])) {
                $errors->add( 'validation', __('Ettevõtet ei leitud, vali ettevõte rippmenüüst!', ELIIDES_TD) );
            }
        }
        /*
        if (!empty($data['shipping_company']) && strtolower($data['shipping_country']) == 'ee') {
            if (empty($data['shipping_company_code'])) {
                $errors->add( 'validation', __('Ettevõtet ei leitud, vali ettevõte rippmenüüst!', ELIIDES_TD) );
            }
        }*/
    }

    public function woocommerce_billing_fields($fields)
    {

        $fields['company_code'] = array(
            'label' => __('Reg nr', ELIIDES_TD),
            'required' => false,
            'clear' => false,
            'type' => 'text',
            'custom_attributes' => array(
                'readonly' => 'readonly',
            ),
            'class' => array('form-row form-row-wide'),
            'priority' => 31,
        );

        $fields['company_kmkr'] = array(
            'label' => __('KMKR nr.', ELIIDES_TD),
            'required' => false,
            'clear' => false,
            'type' => 'text',
            'custom_attributes' => array(
                'readonly' => 'readonly',
            ),
            'class' => array('form-row form-row-wide'),
            'priority' => 32,
        );

        return $fields;
    }

    public function woocommerce_shipping_fields($fields)
    {

        $fields['shipping_company_code'] = array(
            'label' => __('Reg nr', ELIIDES_TD),
            'required' => false,
            'clear' => false,
            'type' => 'text',
            'custom_attributes' => array(
                'readonly' => 'readonly',
            ),
            'class' => array('form-row form-row-wide'),
            'priority' => 31,
        );

        $fields['shipping_company_kmkr'] = array(
            'label' => __('KMKR nr.', ELIIDES_TD),
            'required' => false,
            'clear' => false,
            'type' => 'text',
            'custom_attributes' => array(
                'readonly' => 'readonly',
            ),
            'class' => array('form-row form-row-wide'),
            'priority' => 32,
        );

        return $fields;
    }

    public function enqueue_scripts()
    {
        wp_enqueue_script( 'jquery-ui-core');
        wp_enqueue_script( 'jquery-ui-autocomplete');
    }

    public function woocommerce_after_checkout_billing_form() {
        if (!is_checkout()) {
            return;
        }
        ?>
        <style>
            .company-autocomplete-lds-dual-ring {
                display: inline-block;
                width: 20px;
                height: 20px;
            }
            .company-autocomplete-lds-dual-ring:after {
                content: " ";
                display: block;
                width: 14px;
                height: 14px;
                margin: 8px;
                border-radius: 50%;
                border: 6px solid #333;
                border-color: #333 transparent #333 transparent;
                animation: company-autocomplete-lds-dual-ring 1.2s linear infinite;
            }
            @keyframes company-autocomplete-lds-dual-ring {
                0% {
                    transform: rotate(0deg);
                }
                100% {
                    transform: rotate(360deg);
                }
            }
            .ui-autocomplete {
                position: absolute;
                top: 100%;
                left: 0;
                z-index: 1000;
                display: none;
                float: left;
                min-width: 160px;
                padding: 5px 0;
                margin: 2px 0 0;
                list-style: none;
                font-size: 14px;
                text-align: left;
                background-color: #ffffff;
                border: 1px solid #cccccc;
                border: 1px solid rgba(0, 0, 0, 0.15);
                border-radius: 4px;
                -webkit-box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);
                box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);
                background-clip: padding-box;
            }
            .ui-autocomplete .ui-menu-item {
                padding: 5px 10px;
            }


            .ui-autocomplete > li > div {
                display: block;
                padding: 3px 20px;
                clear: both;
                font-weight: normal;
                line-height: 1.42857143;
                color: #333333;
                white-space: nowrap;
            }

            .ui-state-hover,
            .ui-state-active,
            .ui-state-focus {
                text-decoration: none;
                color: #262626;
                background-color: #f5f5f5;
                cursor: pointer;
            }

            .ui-helper-hidden-accessible {
                border: 0;
                clip: rect(0 0 0 0);
                height: 1px;
                margin: -1px;
                overflow: hidden;
                padding: 0;
                position: absolute;
                width: 1px;
            }
            .ui-autocomplete {
                z-index: 100;
            }
            #company_code_field,
            #company_code_field {
                display: none;
            }
        </style>
        <script type="text/javascript">
            jQuery(function($) {

              const init_eliides_rik = () => {

                if (jQuery('#billing_country').length == 0 && jQuery('#shipping_country').length == 0) {
                  jQuery('body').append('<input type="hidden" id="billing_country" value="EE" />');
                }

                if (jQuery('#billing_country').length > 0) {
                  if (jQuery('#billing_country').val() == 'EE') {
                    jQuery('#billing_company').autocomplete({
                      disabled: false,
                      source: function( request, response ) {
                        $.ajax( {
                          url: '<?php echo admin_url( 'admin-ajax.php' ); ?>?action=eliides_ac_company',
                          data: {
                            term: request.term
                          },
                          dataType: "json",
                          beforeSend: function() {
                            jQuery('#billing_company').closest('.form-row').find('label').append('<span class="company-autocomplete-lds-dual-ring"></span>');
                          },
                          success: function( data ) {

                            jQuery('.company-autocomplete-lds-dual-ring').remove();
                            response( data );
                          }
                        } );
                      },
                      minLength: 2,
                      select: function( event, ui ) {
                        jQuery('#company_kmkr_field').show();

                        if (ui.item.kmkr) {
                          jQuery('#company_code_field').show();
                        }
                        else {
                          jQuery('#company_code_field').hide();
                        }

                        jQuery('#company_code').val(ui.item.code);
                        jQuery('#company_kmkr').val(ui.item.kmkr);
                        jQuery('#billing_postcode').val(ui.item.zipcode);
                        jQuery('#billing_address_1').val(ui.item.address);
                        jQuery('#billing_city').val(ui.item.location);
                        jQuery('#billing_company').blur();
                      }
                    });

                    jQuery('#billing_company').change(function() {
                      if (jQuery('#billing_company').length > 0) {
                        if (jQuery(this).val() && jQuery('#company_code').val()) {
                          jQuery('#company_code_field').show();
                        } else {
                          jQuery('#company_code_field').hide();
                          jQuery('#company_code').val('');
                          jQuery('#company_kmkr').val('');
                          if (jQuery('#billing_country').val() == 'EE') {
                            jQuery(this).val('');
                          }
                        }
                        if (jQuery('#company_kmkr').val()) {
                          jQuery('#company_kmkr_field').show();
                        } else {
                          jQuery('#company_kmkr_field').hide();
                        }
                      }
                    });

                    //jQuery('#billing_company').change();

                  } else {
                    jQuery('#billing_company').autocomplete({
                      disabled: true
                    });
                    jQuery('#company_kmkr_field').hide();
                    jQuery('#company_code_field').hide();
                    jQuery('#company_code').val('');
                    jQuery('#company_kmkr').val('');
                  }
                }

                if (jQuery('#shipping_country').length > 0) {
                  if (jQuery('#shipping_country').val() == 'EE') {
                    jQuery('#shipping_company').autocomplete({
                      disabled: false,
                      source: function( request, response ) {
                        $.ajax( {
                          url: '<?php echo admin_url( 'admin-ajax.php' ); ?>?action=eliides_ac_company',
                          data: {
                            term: request.term
                          },
                          dataType: "json",
                          beforeSend: function() {
                            jQuery('#shipping_company').closest('.form-row').find('label').append('<span class="company-autocomplete-lds-dual-ring"></span>');
                          },
                          success: function( data ) {

                            jQuery('.company-autocomplete-lds-dual-ring').remove();
                            response( data );
                          }
                        } );
                      },
                      minLength: 2,
                      select: function( event, ui ) {
                        jQuery('#shipping_company_kmkr_field').show();

                        if (ui.item.kmkr) {
                          jQuery('#shipping_company_code_field').show();
                        }
                        else {
                          jQuery('#shipping_company_code_field').hide();
                        }

                        jQuery('#shipping_company_code').val(ui.item.code);
                        jQuery('#shipping_company_kmkr').val(ui.item.kmkr);
                        jQuery('#shipping_postcode').val(ui.item.zipcode);
                        jQuery('#shipping_address_1').val(ui.item.address);
                        jQuery('#shipping_city').val(ui.item.location);
                        jQuery('#shipping_company').blur();
                      }
                    });

                    jQuery('#shipping_company').change(function() {
                      if (jQuery('#shipping_company').length > 0) {
                        if (jQuery(this).val() && jQuery('#shipping_company_code').val()) {
                          jQuery('#shipping_company_code_field').show();
                        } else {
                          jQuery('#shipping_company_code_field').hide();
                          jQuery('#shipping_company_code').val('');
                          jQuery('#shipping_company_kmkr').val('');
                          if (jQuery('#shipping_country').val() == 'EE') {
                            jQuery(this).val('');
                          }
                        }
                        if (jQuery('#shipping_company_kmkr').val()) {
                          jQuery('#shipping_company_kmkr_field').show();
                        } else {
                          jQuery('#shipping_company_kmkr_field').hide();
                        }
                      }
                    });

                    //jQuery('#shipping_company').change();

                  } else {
                    jQuery('#shipping_company').autocomplete({
                      disabled: true
                    });
                    jQuery('#shipping_company_kmkr_field').hide();
                    jQuery('#shipping_company_code_field').hide();
                    jQuery('#shipping_company_code').val('');
                    jQuery('#shipping_company_kmkr').val('');
                  }
                }


                jQuery('#billing_company').focusin(function() {
                  if (jQuery('#billing_country').val() == 'EE') {
                    jQuery(this).val('');
                    jQuery('#company_code').val('');
                    jQuery('#company_kmkr').val('');
                  }
                });

                jQuery('#shipping_company').focusin(function() {
                  if (jQuery('#shipping_country').val() == 'EE') {
                    jQuery(this).val('');
                    jQuery('#shipping_company_code').val('');
                    jQuery('#shipping_company_kmkr').val('');
                  }
                });

              }

              init_eliides_rik();

                jQuery('#billing_country, #shipping_country').change(function() {
                  init_eliides_rik();
                });





            });
        </script>
        <?php
    }

    public function get_companies() {
        $res = $this->_api->sendRequest($this->_api_key, 'company-autocomplete', 'get-companies', array(
            'software' => 'company_autocomplete',
            'name' => $_GET['term'],
        ));

        if ($res['status'] > 0) {
            echo json_encode($res['data']);
        }
        else {
            echo json_encode(array());
        }

        exit;
    }

}
