<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

if ( ! class_exists( 'Veebiekspert_Payment_Estcard' ) ) :


class Veebiekspert_Payment_Estcard {
    
    /**
     * API
     * 
     * @var Veebiekspert_API
     */
    protected $_api;
    
    protected $_api_key;
    
    /**
     * Estcard banklink WC module
     * 
     * @var Veebiekspert_Payment_Estcard_WC
     */
    protected $_wc_module;
    
    /**
     * Consturctor
     * 
     * @param Veebiekspert_API $api
     */
    public function __construct(Veebiekspert_API $api) {
        
        $this->_api = $api;
        
        $veebiekspert_active_module = get_option('veebiekspert_active_module');
        
        if (!in_array('estcard', (array) $veebiekspert_active_module)) {
            return;
        }
        
        $this->_api_key = get_option('veebiekspert_module_estcard_api_key');
        
        if ($this->_api_key) {
            
            add_action('plugins_loaded', array($this, 'init_module'));
            
            add_action('woocommerce_payment_gateways', array($this, 'woocommerce_payment_gateways'));
            add_filter('woocommerce_available_payment_gateways', array($this, 'woocommerce_available_payment_gateways'));
            
        }
        
    }

    public function woocommerce_available_payment_gateways($allowed_gateways) {
        $all_gateways = WC()->payment_gateways->payment_gateways();
        $allowed_gateways['eliides_estcard'] = $all_gateways['eliides_estcard'];
        return $allowed_gateways;
    }
    
    public function woocommerce_payment_gateways($methods) {
        include_once( VE_ABS_PATH . 'payment/wc-module/estcard.php' );
        
        $methods['eliides_estcard'] = 'Veebiekspert_Payment_Estcard_WC';
        
        return $methods;
        
    }
    
    public function init_module() {
        include_once( VE_ABS_PATH . 'payment/wc-module/estcard.php' );
        new Veebiekspert_Payment_Estcard_WC();
    }
    
    public function getPaymentForm($total, $reference, $returnLink, $title) {
        $res = $this->_api->sendRequest($this->_api_key, 'estcard', 'get-form', array(
            'software' => 'estcard',
            'bank_params' => get_option('veebiekspert_module_estcard_params'),
            'total' => $total,
            'reference' => $reference,
            'title' => $title,
            'return_url' => $returnLink,
        ));
        
        return $res;
    }
    
    public function validateResponse($params = array()) {
        $res = $this->_api->sendRequest($this->_api_key, 'estcard', 'validate-response', array(
            'software' => 'estcard',
            'bank_params' => get_option('veebiekspert_module_estcard_params'),
            'params' => $params,
        ));
        
        return $res;
    }
    
}

endif; 