<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

if ( ! class_exists( 'Veebiekspert_Payment_Danske_WC' ) ) :

class Veebiekspert_Payment_Danske_WC extends WC_Payment_Gateway {

    public $id = 'eliides_danske';
    
    public $has_fields = false;
    
    public $supports = array( 'products' );
    
    protected $_danske;
    
    public function __construct() {
        $this->_danske = Veebiekspert_Modules()->getDanske();
        $this->title = __('Danske pangalink', ELIIDES_TD);
		
		$this->icon = apply_filters('woocommerce_eliides_danske_icon', plugins_url('/img/icons/danske.jpg', __FILE__));
        
		$this->enabled = true;

        $this->init_settings();
		
        add_action('init', array($this, 'banklink_response'));
        add_action('before_woocommerce_pay', array($this, 'before_woocommerce_pay'));
    }
    
    public function before_woocommerce_pay() {
        $order_id = (int) $_GET['order'];
        $order = new WC_Order((int) $order_id);

        if (get_post_meta($order_id, '_eliides_danske_paid', true)) {
            return false;
        }
        
        if ($order->get_payment_method() !== $this->id) {
            return false;
        }
        
        $url = home_url() . '/?eliides_validate_payment=' . $this->id . '&order_id=' . $order_id;
        
        $title = sprintf(__('Tellimus nr %s', ELIIDES_TD), $order_id);
        
        $form = $this->_danske->getPaymentForm($order->get_total(), $order_id, $url, $title);
        
        echo $form['data'];
    }
    
    public function banklink_response() {
        if (!isset($_GET['eliides_validate_payment'])) {
            return;
        }
        if ($_GET['eliides_validate_payment'] !== $this->id) {
            return;
        }
        
        $order_id = $_GET['order_id'];
        $order = new WC_Order((int) $order_id);
        
        

        $result = $this->_danske->validateResponse($_REQUEST);
        
        if ($result['data']['status'] == 'success') {
            
            do_action('eliides_before_success_payment', $order_id);
            
            $order->add_order_note(__('Makse õnnestus', ELIIDES_TD));
            $order->payment_complete();
            
            do_action('eliides_after_success_payment', $order_id);
            
            $url = $this->get_return_url($order);
            
        }
        else {
            
            do_action('eliides_before_failed_payment');
            
            $order->add_order_note(__('Makse ebaõnnestus', ELIIDES_TD));
            
            do_action('eliides_after_failed_payment');
            
            $url = home_url();
            
        }
        
        wp_redirect($url);
        exit;
    }
    
    public function process_payment($order_id) {
        $order = new WC_Order($order_id);
        
        $redirectUrl = add_query_arg('order', $order_id, add_query_arg('key', $order->get_order_key(), $order->get_checkout_payment_url(true)));

        return array(
            'result' => 'success',
            'redirect' => $redirectUrl,
        );
    }
    
    
}


endif; 