<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

if ( ! class_exists( 'Veebiekspert_Payment_Swedbank_WC' ) ) :

class Veebiekspert_Payment_Swedbank_WC extends WC_Payment_Gateway {

    public $id = 'eliides_swedbank';

    public $has_fields = false;
    
    public $supports = array( 'products' );
    
    protected $_swedbank;

    const PAYMENT_METHOD_NAME = 'swedbank_selected_method';
    
    public function __construct() {
        $this->_swedbank = Veebiekspert_Modules()->getSwedbank();
        $this->title = __('Swedbank pangalink', ELIIDES_TD);
        $this->icon = apply_filters('woocommerce_eliides_swedbank_icon', plugins_url('/img/icons/swedbank.jpg', __FILE__));


        $options = get_option('veebiekspert_module_swedbank_params');
        if ($options['other_banks'] == 'yes') {
            $this->title = __('Pangalink', ELIIDES_TD);
            $this->icon = null;
            $this->has_fields = true;
        }
		

		$this->enabled = true;

        $this->init_settings();
		
        add_action('init', array($this, 'banklink_response'));
        add_action('before_woocommerce_pay', array($this, 'before_woocommerce_pay'));
    }
    
    public function before_woocommerce_pay() {
        $order_id = (int) $_GET['order'];
        $order = new WC_Order((int) $order_id);
        
        $payment_gateway = wc_get_payment_gateway_by_order( $order );
    
        if ($order->get_payment_method() !== $this->id) {
            return false;
        }
        
        if (get_post_meta($order_id, '_eliides_swedbank_paid', true)) {
            return false;
        }
        
        $url = home_url() . '/?eliides_validate_payment=' . $this->id . '&order_id=' . $order_id;
        
        $title = sprintf(__('Tellimus nr %s', ELIIDES_TD), $order_id);

        $paymentMethod = get_post_meta($order_id, '_eliides_swedbank_transaction_payment_method', true);
        
        $form = $this->_swedbank->getPaymentForm($order->get_total(), $order_id, $url, $title, $paymentMethod);
        
        echo $form['data'];
    }

    public function validate_fields() {
        $options = get_option('veebiekspert_module_swedbank_params');
        if ($options['other_banks'] !== 'yes') {
            return true;
        }
        $method = $_POST[self::PAYMENT_METHOD_NAME];

        if (empty($method)) {
            wc_add_notice(__('Vali pank', ELIIDES_TD), 'error');
            return false;
        }
        return true;
    }
    
    public function banklink_response() {
        if (!isset($_GET['eliides_validate_payment'])) {
            return;
        }
        if ($_GET['eliides_validate_payment'] !== $this->id) {
            return;
        }
        
        $order_id = $_GET['order_id'];
        $order = new WC_Order((int) $order_id);
        
        

        $result = $this->_swedbank->validateResponse($_REQUEST);
        
        if ($result['data']['status'] == 'success') {
            
            do_action('eliides_before_success_payment', $order_id);
            
            $order->add_order_note(__('Makse õnnestus', ELIIDES_TD));
            $order->payment_complete();
            
            do_action('eliides_after_success_payment', $order_id);
            
            $url = $this->get_return_url($order);
            
        }
        else {

            do_action('eliides_before_failed_payment');
            
            $order->add_order_note(__('Makse ebaõnnestus', ELIIDES_TD));
            
            do_action('eliides_after_failed_payment');
            
            $url = home_url();
            
        }
        
        wp_redirect($url);
        exit;
    }


    public function payment_fields() {
        $options = get_option('veebiekspert_module_swedbank_params');
        if ($options['other_banks'] !== 'yes') {
            return;
        }
        $uniqid = uniqid();

        $allMethods = array(
            array(
                'name' => 'swedbank',
                'logo_url' => apply_filters('woocommerce_eliides_swedbank_icon', plugins_url('/img/icons/swedbank.jpg', __FILE__)),
            ),
            array(
                'name' => 'lhv',
                'logo_url' => apply_filters('woocommerce_eliides_lhv_icon', plugins_url('/img/icons/lhv.jpg', __FILE__)),
            ),
            array(
                'name' => 'seb',
                'logo_url' => apply_filters('woocommerce_eliides_seb_icon', plugins_url('/img/icons/seb.jpg', __FILE__)),
            ),
        );
        ?>
        <input type="hidden" id="<?php echo $uniqid; ?>" name="<?php echo self::PAYMENT_METHOD_NAME; ?>" value="" />
        <style>
            .veebiekspert-methods-<?php echo $uniqid; ?> .method-item {
                border: 3px solid rgba(0,0,0,0);
                opacity: 0.7;
                padding: 5px;
                cursor: pointer;
                border-radius: 3px;
                display: inline-block;
                margin: 5px;

            }
            .veebiekspert-methods-<?php echo $uniqid; ?> .method-item img {
                height: 35px;
                margin: 0 !important;
                padding: 0;
            }
            .veebiekspert-methods-<?php echo $uniqid; ?> .method-item:hover {
                opacity: 0.9;
                border: 3px solid rgba(0,0,0,0.4);
            }
            .veebiekspert-methods-<?php echo $uniqid; ?> .method-item.selected {
                opacity: 1;
                border: 3px solid #fff;
                background: #fff;
                -webkit-box-shadow: 5px 5px 5px 0px rgba(0,0,0,0.2);
                -moz-box-shadow: 5px 5px 5px 0px rgba(0,0,0,0.2);
                box-shadow: 5px 5px 5px 0px rgba(0,0,0,0.2);
            }
        </style>
        <div class="veebiekspert-methods-<?php echo $uniqid; ?>">
            <?php foreach ($allMethods as $banklink): ?>

                    <div class="method-item" banklink="<?php echo esc_html($banklink['name']); ?>">
                        <img src="<?php echo esc_html($banklink['logo_url']); ?>" alt="" />
                    </div>

            <?php endforeach; ?>
        </div>

        <script type="text/javascript">
            jQuery(function() {
                jQuery('#<?php echo $uniqid; ?>').val('');

                jQuery('.veebiekspert-methods-<?php echo $uniqid; ?> .method-item').click(function() {
                    jQuery('.veebiekspert-methods-<?php echo $uniqid; ?> .method-item').removeClass('selected');
                    jQuery(this).addClass('selected');
                    jQuery('#<?php echo $uniqid; ?>').val(jQuery(this).attr('banklink'));
                });
            });
        </script>
        <?php
    }
    
    public function process_payment($order_id) {
        $order = new WC_Order($order_id);
        
        $redirectUrl = add_query_arg('order', $order_id, add_query_arg('key', $order->get_order_key(), $order->get_checkout_payment_url(true)));
        $method = $_POST[self::PAYMENT_METHOD_NAME];

        if (!empty($method)) {
            update_post_meta($order_id, '_eliides_swedbank_transaction_payment_method', $method);
        }

        return array(
            'result' => 'success',
            'redirect' => $redirectUrl,
        );
    }
    
    
}


endif; 