<?php


if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}



function eliides_init_dhl() {

	if ( ! class_exists( 'Veebiekspert_Transport_DHL' ) && class_exists( 'WC_Shipping_Method' ) ) :

		class Veebiekspert_Transport_DHL extends WC_Shipping_Method {

			const SHIPPING_METHOD = '_eliides_shipping_method';
			const SEND_TO_SERVER = 'dhl_send_to_server';
			const PACKAGE_BARCODE = '_eliides_dhl_barcode';
			const PRINT_LABEL = 'dhl_print_label';
			const XML_RESPONSE_STRING = 'eliides_dhl_response';

			public function __construct() {

				$this->id                 = 'eliides_dhl';

				$this->method_title       = __('DHL', ELIIDES_TD);
				$this->method_description = __('DHL', ELIIDES_TD);

				$this->title       = __('DHL', ELIIDES_TD);

				add_filter( 'woocommerce_shipping_methods', array(&$this, 'add_shipping_method'));

                add_filter( 'eliides_dhl_custom_price', array($this, 'eliides_dhl_custom_price'), 10, 2);

				$this->init_settings();

				add_action('woocommerce_checkout_update_order_meta', array($this, 'checkout_update_order_meta'), 10, 2);

				if (is_admin()) {

					add_filter('woocommerce_admin_order_actions', array($this, 'send_to_server_btn'), 10, 2);

					add_action('wp_ajax_' . self::PRINT_LABEL, array($this, 'print_label_action'));
				}


			}

			public function eliides_dhl_custom_price($price, $country = null) {
                return $price;
            }

			public function send_to_server_btn($actions, $order) {

				$method_id = get_post_meta($order->get_id(), self::SHIPPING_METHOD, true);

				if ($method_id !== $this->id) {
					return $actions;
				}

				if ($order) {
					$actions[self::PRINT_LABEL] = array(
						'action' => self::PRINT_LABEL,
						'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::PRINT_LABEL . '&order_id=' . $order->get_id()), 'eliides-itella-print'),
						'name' => __('Prindi pakisilt', ELIIDES_TD)
					);
				}

				return $actions;

			}

			public function print_label_action() {
				$order_id = absint($_GET['order_id']);

				$xml = get_post_meta($order_id, self::XML_RESPONSE_STRING, true);

				if (empty($xml)) {

					if (!$order = wc_get_order($order_id)) {
                        return;
                    }

					if ($order) {

						$dhl = get_option('veebiekspert_module_dhl_params');

						$firstname = $order->get_billing_first_name();
						$lastname = $order->get_billing_last_name();

						if (!empty($order->get_shipping_first_name()) && !empty($order->get_shipping_last_name())) {
							$firstname = $order->get_shipping_first_name();
							$lastname = $order->get_shipping_last_name();
						}

						$company = $name = trim(implode(' ', array($firstname, $lastname)));

						if ($order->get_shipping_company()) {
							$company = $order->get_shipping_company();
						}

						$phone = $order->get_billing_phone();
						$email = $order->get_billing_email();

						$country = strtoupper(Veebiekspert_Modules()->getOrderShippingCountry($order));

						$dhl['destination'] = array(
							'zipcode' => $order->get_shipping_postcode(),
							'city' => $order->get_shipping_city(),
							'state' => $order->get_shipping_state(),
							'country' => $country,
							'address_1' => $order->get_shipping_address_1(),
							'address_2' => $order->get_shipping_address_2(),
						);
						$dhl['order_total'] = $order->get_total();

						$dhl['customer'] = array(
							'name' => $name,
							'phone' => $phone,
							'email' => $email,
							'company_name' => $company,
						);

						$result = $this->sendRequest('print-label', $dhl);

						if ($result['status'] == 1) {
							update_post_meta($order_id, self::XML_RESPONSE_STRING, eliides_sanitize_text_or_array_field($result['data']));

							$res = new SimpleXMLElement($result['data']);

							$plates = '';
							foreach ((array) $res->Pieces as $piece) {
								foreach ((array) $piece as $p) {
									$plates .= $p->LicensePlate . PHP_EOL;
								}
							}

							$dhl_tracking = sprintf(__('DHL tellimuse nr: %s', ELIIDES_TD), (string) $res->AirwayBillNumber);
							$dhl_tracking .= PHP_EOL . PHP_EOL . $plates;

							$order->add_order_note($dhl_tracking, false);
						}

						$xml = $result['data'];
					}

				}

				$res = new SimpleXMLElement($xml);

				$pdf = base64_decode((string) $res->LabelImage->OutputImage);

				header("Content-type:application/pdf");
				header("Content-Disposition:attachment;filename=pakisilt_$order_id.pdf");
				echo $pdf;
				exit;
			}

			public function checkout_update_order_meta($order_id, $post) {

				$shipping_method = eliides_arr_get($post, ['shipping_method']);

				if (in_array($this->id, (array) $shipping_method)) {

					update_post_meta($order_id, self::SHIPPING_METHOD, eliides_sanitize_text_or_array_field($this->id));

				}
			}

			public function add_shipping_method( $methods ) {
				$methods[$this->id] = $this;
				return $methods;
			}


			public function sendRequest($action, $params = array()) {
				$apiKey = get_option('veebiekspert_module_dhl_api_key');

				$params['software'] = 'dhl';

				return Veebiekspert_Modules()->getApi()->sendRequest($apiKey, 'dhl', $action, $params);
			}


			/**
			 * This function is used to calculate the shipping cost. Within this function we can check for weights, dimensions and other parameters.
			 *
			 * @access public
			 * @param mixed $package
			 * @return void
			 */
			public function calculate_shipping( $package = array() ) {
				$country = strtoupper(eliides_arr_get($package, ['destination', 'country']));

				$dhl = get_option('veebiekspert_module_dhl_params', []);
				$prices = eliides_arr_get($dhl, ['prices']);

				$request = $this->sendRequest('get-zone', array(
					'country' => $country,
				));

				if ($request['status'] == 0) {
					return false;
				}

				$price = $prices[$request['data']];

				$price = apply_filters('eliides_dhl_custom_price', $price, $country);

				$items = array();

				$cartTotal = 0;

				foreach ($package['contents'] as $content) {
					$cartTotal += $content['line_subtotal'];
				}

				$hasCoupon = false;

				if (WC()->cart->applied_coupons) {
					foreach (WC()->cart->applied_coupons as $code) {
						$coupon = new WC_Coupon($code);
                        if ($coupon->is_valid_for_cart() && $coupon->get_free_shipping()) {
							$hasCoupon = true;
							break;
						}
					}
				}

				if ($hasCoupon || (strlen($price['free_from']) > 0 && $price['free_from'] <= $cartTotal)) {

					$price = 0;

				}
				else {

					$price = $price['price'];

				}

				$rate = array(
					'id' => $this->id,
					'label' => $this->title,
					'cost' =>  $price
				);

				$this->add_rate( $rate );
			}


		}

	endif;


    $veebiekspert_active_module = get_option('veebiekspert_active_module');

    if (in_array('dhl', (array) $veebiekspert_active_module)) {
        new Veebiekspert_Transport_DHL();
    }


}

add_action('plugins_loaded', 'eliides_init_dhl');


