<?php


if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}



function eliides_init_dpd_parcel() {

	if ( ! class_exists( 'Veebiekspert_Transport_dpd_parcel' ) && class_exists( 'WC_Shipping_Method' )) :

		class Veebiekspert_Transport_DpdParcel extends WC_Shipping_Method {

			const SHIPPING_METHOD = '_eliides_shipping_method';
			const PARCEL = '_eliides_parcel';
			const SEND_TO_SERVER = 'dpd_send_to_server';
			const PARCEL_SIZE = '_eliides_dpd_parcel_size';
			const PACKAGE_BARCODE = '_eliides_dpd_barcode';
			const PRINT_LABEL = 'dpd_print_label';

			protected $_parcels = array();

			public function __construct() {

				$this->id                 = 'eliides_dpd_parcel';

				$this->method_title       = __('DPD pakiautomaat', ELIIDES_TD);
				$this->method_description = null;

				$this->title       = __('DPD pakiautomaat', ELIIDES_TD);

                $this->enabled = 'yes';

				add_filter( 'woocommerce_shipping_methods', array(&$this, 'add_shipping_method'));

				Veebiekspert_Modules()->setDpdParcel($this);

                $this->init();

                $veebiekspert_active_module = get_option('veebiekspert_active_module');

                if (in_array('dpd_parcel', (array) $veebiekspert_active_module)) {
                    $options = (array) get_option('veebiekspert_module_dpd_parcel_params');
                    if (eliides_arr_get($options, 'add_package_tracking_details_to_email') == 'yes') {
                        add_action('woocommerce_email_order_details', array($this, 'woocommerce_email_order_details'), 10, 4);
                    }

                    add_action('woocommerce_order_actions', [$this, 'woocommerce_order_actions']);
                    add_action('woocommerce_order_action_' . self::PRINT_LABEL, [$this, 'order_action_print_pdf']);
                }

                add_action('manage_shop_order_posts_custom_column', array($this, 'manage_shop_order_posts_custom_column'), 50, 2);
                add_action('woocommerce_shop_order_list_table_custom_column', array($this, 'woocommerce_shop_order_list_table_custom_column'), 50, 2);

				add_action('woocommerce_review_order_after_shipping', array(&$this, 'pickup_location'));
				add_action('woocommerce_after_checkout_validation', array($this, 'after_checkout_validation'));
                add_action('woocommerce_checkout_create_order', array($this, 'woocommerce_checkout_create_order'), 10, 2);
				add_filter('woocommerce_order_shipping_method', array($this, 'alter_shipping_name_in_totals'), 10, 2);

				if (is_admin()) {
					add_action('woocommerce_process_shop_order_meta', array($this, 'process_shop_order_meta'), 99, 2);
					add_action('woocommerce_admin_order_data_after_shipping_address', array($this, 'admin_order_pickup_location'));

					add_filter('woocommerce_admin_order_actions', array($this, 'send_to_server_btn'), 10, 2);

					add_action('wp_ajax_' . self::SEND_TO_SERVER, array($this, 'send_to_server_action'));
					add_action('wp_ajax_' . self::PRINT_LABEL, array($this, 'print_label_action'));
				}
                if (eliides_is_module_active('dpd_parcel')) {
                    add_action('woocommerce_order_status_on-hold', array($this, 'check_if_send_to_server_automatic'));
                    add_action('woocommerce_order_status_processing', array($this, 'check_if_send_to_server_automatic'));
                    add_action('woocommerce_order_status_completed', array($this, 'check_if_send_to_server_automatic'));
                }

			}

            public function woocommerce_order_actions($actions)
            {
                $actions[self::PRINT_LABEL] = 'Trüki DPD pakiautomaadi pakisilt';
                return $actions;
            }

            public function order_action_print_pdf($order)
            {
                $this->print_pdf($order->get_id());
            }

            public function manage_shop_order_posts_custom_column($column_name, $order_id) {
                if ($column_name == 'shipping_address') {
                    if (get_post_meta($order_id, self::SHIPPING_METHOD, true) == $this->id) {
                        $barcodes = (array) get_post_meta($order_id, self::PACKAGE_BARCODE, true);
                        foreach ($barcodes as $barcode) {
                            $link = '<a href="' . $this->getTrackingLink($barcode) . '" target="_blank"> ' . esc_html($barcode) . '</a>';
                            echo '<div style="font-weight: bold;">Jälgimiskood: ' . $link . '</div>';
                        }

                    }
                }
            }

            public function woocommerce_shop_order_list_table_custom_column($column_name, \WC_Order $order) {
                if ($column_name == 'shipping_address') {
                    if (get_post_meta($order->get_id(), self::SHIPPING_METHOD, true) == $this->id) {
                        $barcodes = (array) get_post_meta($order->get_id(), self::PACKAGE_BARCODE, true);
                        foreach ($barcodes as $barcode) {
                            $link = '<a href="' . $this->getTrackingLink($barcode) . '" target="_blank"> ' . esc_html($barcode) . '</a>';
                            echo '<div style="font-weight: bold;">Jälgimiskood: ' . $link . '</div>';
                        }

                    }
                }
            }

            public function getTrackingLink($code) {
                return 'https://www.dpdgroup.com/ee/mydpd/my-parcels/track?lang=ee_ee&parcelNumber=' . $code;
            }

            public function woocommerce_email_order_details( $order, $sent_to_admin, $plain_text, $email ) {

                if ( 'customer_completed_order' == $email->id ) {
                    $order_id = $order->get_id();

                    $tracking_number = null;
                    $tracking_url = null;
                    $tracking_provider = null;

                    if ($code = get_post_meta($order_id, self::PACKAGE_BARCODE, true)) {
                        if (is_array($code)) {
                            $code = array_shift($code);
                        }
                        $tracking_number = $code;
                        $tracking_provider = $this->title;
                        $tracking_url = $this->getTrackingLink($code);
                    }

                    if ( empty( $tracking_number ) || empty( $tracking_url ) ) {
                        return;
                    }

                    if ( $plain_text ) {
                        printf( __("\nSinu tellimus jälgimiskoodiga %s on edastatud kullerile %s. Pakki saab jälgida aadressilt %s.\n", ELIIDES_TD), esc_html( $tracking_number ), $tracking_provider, esc_url( $tracking_url, array( 'http', 'https' ) ) );
                    }
                    else {
                        printf( __('<p>Sinu tellimus jälgimiskoodiga <strong>%s</strong> on edastatud kullerile <strong>%s</strong>. Pakki saab jälgida aadressilt <strong><a href="%s">%s</a></strong>.</p>', ELIIDES_TD), esc_html( $tracking_number ), $tracking_provider, esc_url( $tracking_url, array( 'http', 'https' ) ), esc_url( $tracking_url, array( 'http', 'https' ) ) );
                    }
                }
            }

            function init() {
                // Load the settings API
                $this->init_form_fields();
                $this->init_settings();

                add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );
            }

            function get_admin_options_html() {
                $veebiekspert_active_module = (array) get_option('veebiekspert_active_module');
                ?>
                <div class="veebiekspert-setting-block">

                    <?php
                    $dpd = (array) get_option('veebiekspert_module_dpd_parcel_params');
                    $dpd['allowed_countries'] = (array) eliides_arr_get($dpd, ['allowed_countries'], array());
                    $countries = Veebiekspert_Modules()->getEuCountries();
                    ?>
                    <input type="hidden" name="is_module_active" value="0" />
                    <h2><label><input type="checkbox" name="is_module_active"<?php if (in_array('dpd_parcel', $veebiekspert_active_module)): ?> checked<?php endif; ?> value="1" /> Aktiivne</label></h2>

                    <div class="settings-block-inner">

                        <div class="ve-form-group">
                            <label>E-liides litsentsi võti</label>
                            <input type="text" id="veebiekspert_module_dpd_parcel_api_key" name="veebiekspert_module_dpd_parcel_api_key" value="<?php echo get_option('veebiekspert_module_dpd_parcel_api_key'); ?>" />
                            <a href="https://www.e-liides.ee" target="_blank">Registreeri võti (7 päeva tasuta)</a>
                        </div>

                        <div class="ve-form-group">
                            <label>DPD kasutaja</label>
                            <input type="text" name="veebiekspert_module_dpd_parcel_params[username]" value="<?php echo @esc_html(eliides_arr_get($dpd, ['username'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>DPD parool</label>
                            <input type="password" name="veebiekspert_module_dpd_parcel_params[password]" value="<?php echo @esc_html(eliides_arr_get($dpd, ['password'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Aktiivne keskkond</label>

                            <?php

                            $options = array(
                                '0' => 'Live ehk reaalne keskkond',
                                '1' => 'Test ehk süsteemi testimine',
                            );

                            $selected = (int) eliides_arr_get($dpd, ['is_test']);
                            ?>

                            <select name="veebiekspert_module_dpd_parcel_params[is_test]">
                                <?php foreach ($options as $k => $i): ?>
                                    <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Pakisildi mõõt</label>
                            <select name="veebiekspert_module_dpd_parcel_params[format]">
                                <?php foreach (array('A4', 'A6') as $format): ?>
                                    <option value="<?php echo $format; ?>"<?php if ($format == eliides_arr_get($dpd, 'format')): ?> selected<?php endif; ?>><?php echo $format; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Paki andmed saadetakse automaatselt</label>

                            <?php

                            $options = array(
                                '' => 'Automaatselt ei saadeta, pakisildi saab ainult käsitsi tellimuste nimekirjast',
                                'woocommerce_order_status_on-hold' => 'Kui tellimus on vähemalt ootel olekus',
                                'woocommerce_order_status_processing' => 'Kui tellimus on vähemalt töötluses olekus',
                                'woocommerce_order_status_completed' => 'Kui tellimus on täidetud',
                            );

                            $selected = eliides_arr_get($dpd, ['send_to_server_automatic']);
                            ?>

                            <select name="veebiekspert_module_dpd_parcel_params[send_to_server_automatic]">
                                <?php foreach ($options as $k => $i): ?>
                                    <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Muuda tellimuse olek peale pakisildi printimist valitud olekusse</label>

                            <?php
                            $options = array(
                                '' => 'Ei muuda tellimuse olekut',
                            );
                            foreach (wc_get_order_statuses() as $orderStatus => $orderStatusValue) {
                                $options[esc_html(str_replace('wc-', '', $orderStatus))] = esc_html($orderStatusValue);
                            }
                            $selected = eliides_arr_get($dpd, ['mark_order_completed_after_packing_split_print']);
                            ?>

                            <select name="veebiekspert_module_dpd_parcel_params[mark_order_completed_after_packing_split_print]">
                                <?php foreach ($options as $k => $i): ?>
                                    <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Lisa paki jälgimiskood ja kulleri info täidetud tellimuse e-mailile kaasa</label>

                            <?php
                            $options = array(
                                'no' => 'Ei lisa',
                                'yes' => 'Lisa e-mailile info kaasa',
                            );
                            $selected = eliides_arr_get($dpd, ['add_package_tracking_details_to_email']);
                            ?>

                            <select name="veebiekspert_module_dpd_parcel_params[add_package_tracking_details_to_email]">
                                <?php foreach ($options as $k => $i): ?>
                                    <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Saada pakisildi koopia e-mailile</label>
                            <input type="text" name="veebiekspert_module_dpd_parcel_params[send_pdf_copy]" value="<?php echo @esc_html(eliides_arr_get($dpd, ['send_pdf_copy'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Kuva telefonis klassikalist pakiautomaadi valikut</label>
                            <input type="hidden" name="veebiekspert_module_dpd_parcel_params[classic_mobile_view]" value="no" />
                            <input type="checkbox" style="width: auto;" name="veebiekspert_module_dpd_parcel_params[classic_mobile_view]" value="yes"<?php if (eliides_arr_get($dpd, ['classic_mobile_view']) == 'yes'): ?> checked<?php endif; ?> />
                        </div>

                        <div class="ve-form-group">
                            <label>Hinnad</label>

                            <?php
                            $defaultPrices = array(
                                'EE' => array(
                                    'xs' => 2.15,
                                    's' => 2.49,
                                    'm' => 3.32,
                                    'l' => 4.07,
                                    'free_from' => '',
                                ),
                            );

                            $prices = eliides_arr_get($dpd, ['prices'], array());
                            if (empty($prices)) {
                                $prices = $defaultPrices;
                            }
                            ?>

                            <table class="widefat fixed" style="margin-top: 20px;">
                                <thead>
                                <tr>
                                    <th>Hinnad km-ta</th>
                                    <th>XS hind</th>
                                    <th>S hind</th>
                                    <th>M hind</th>
                                    <th>L hind</th>
                                    <th>Tasuta alates</th>
                                    <th></th>
                                </tr>
                                </thead>
                                <tbody id="dpd-prices-table">
                                <?php foreach ($prices as $country => $sizes): ?>
                                    <tr>
                                        <td><?php echo @esc_html($countries[$country]); ?></td>
                                        <?php foreach ($sizes as $size => $price): ?>
                                            <td><input style="width: 100%;" type="number" step="0.01" name="veebiekspert_module_dpd_parcel_params[prices][<?php echo $country; ?>][<?php echo $size; ?>]" value="<?php echo eliides_number_format($price, 2, '.', ''); ?>" /></td>
                                        <?php endforeach; ?>
                                        <td><span style="color: red; cursor: pointer;" onclick="jQuery(this).closest('tr').remove();">Kustuta</span></td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td colspan="7">
                                        <select id="dpd-new-country">
                                            <?php foreach ($countries as $countryCode => $name): ?>
                                                <option value="<?php echo @esc_html($countryCode); ?>"><?php echo @esc_html($name); ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <button class="button" onclick="return addNewDpdRow();">Lisa</button>
                                    </td>
                                </tr>
                                </tfoot>
                            </table>

                            <script type="text/javascript">
                                function addNewDpdRow() {
                                    var html = jQuery('#new-dpd-row-template').html();

                                    html = html.replace(new RegExp('country_name', 'g'), jQuery('#dpd-new-country option:selected').text());
                                    html = html.replace(new RegExp('country', 'g'), jQuery('#dpd-new-country').val());

                                    jQuery('#dpd-prices-table').append(html);
                                    return false;
                                }
                            </script>

                            <script type="text/template" id="new-dpd-row-template">
                                <tr>
                                    <td>country_name</td>
                                    <td><input style="width: 100%;" type="number" step="0.01" name="veebiekspert_module_dpd_parcel_params[prices][country][xs]" value="" /></td>
                                    <td><input style="width: 100%;" type="number" step="0.01" name="veebiekspert_module_dpd_parcel_params[prices][country][s]" value="" /></td>
                                    <td><input style="width: 100%;" type="number" step="0.01" name="veebiekspert_module_dpd_parcel_params[prices][country][m]" value="" /></td>
                                    <td><input style="width: 100%;" type="number" step="0.01" name="veebiekspert_module_dpd_parcel_params[prices][country][l]" value="" /></td>
                                    <td><input style="width: 100%;" type="number" step="0.01" name="veebiekspert_module_dpd_parcel_params[prices][country][free_from]" value="" /></td>
                                    <td><span style="color: red; cursor: pointer;" onclick="jQuery(this).closest('tr').remove();">Kustuta</span></td>
                                <tr>
                            </script>

                        </div>

                    </div>

                </div>
                <?php
            }

            public function process_admin_options()
            {
                $this->init_settings();

                $post_data = $this->get_post_data();
                update_option('veebiekspert_module_dpd_parcel_api_key', $post_data['veebiekspert_module_dpd_parcel_api_key']);
                update_option('veebiekspert_module_dpd_parcel_params', $post_data['veebiekspert_module_dpd_parcel_params']);

                $activeModules = (array) get_option('veebiekspert_active_module', []);
                $module = 'dpd_parcel';

                if (!empty($post_data['is_module_active'])) {
                    if (!in_array($module, $activeModules)) {
                        $activeModules[] = $module;
                        update_option('veebiekspert_active_module', $activeModules);
                    }
                }
                else {
                    $key = array_search($module, $activeModules);
                    if (false !== $key) {
                        unset($activeModules[$key]);
                        update_option('veebiekspert_active_module', $activeModules);
                    }
                }

            }

            public function check_if_send_to_server_automatic($order_id) {
                $dpd = get_option('veebiekspert_module_dpd_parcel_params');
                $trigger = eliides_arr_get($dpd, ['send_to_server_automatic']);

                if ($order = wc_get_order($order_id)) {

                    if ($trigger == 'woocommerce_order_status_on-hold') {

                        if ($order->has_status(array('on-hold', 'processing', 'completed'))) {
                            $this->send_order_to_server_final($order_id);
                        }
                    }
                    elseif ($trigger == 'woocommerce_order_status_processing') {

                        if ($order->has_status(array('processing', 'completed'))) {
                            $this->send_order_to_server_final($order_id);
                        }
                    }
                    elseif ($trigger == 'woocommerce_order_status_completed') {

                        if ($order->has_status(array('completed'))) {
                            $this->send_order_to_server_final($order_id);
                        }
                    }

                }

            }

			public function print_label_action($order) {
				$order_id = absint($_GET['order_id']);

                $this->print_pdf($order_id);
			}

            public function print_pdf($order_id)
            {
                $dpd = get_option('veebiekspert_module_dpd_parcel_params', []);
                $dpd = apply_filters('eliides_dpd_parcel_options', $dpd, $order_id);

                if ($newStatus = eliides_arr_get($dpd, ['mark_order_completed_after_packing_split_print'])) {
                    if ($order = wc_get_order($order_id)) {
                        if (!$order->has_status(array($newStatus))) {
                            $order->update_status($newStatus);
                        }
                    }
                }

                $barcodes = [];
                foreach (get_post_meta($order_id, self::PACKAGE_BARCODE, true) as $barcode) {
                    $barcodes[] = $barcode;
                }

                $barcodes = apply_filters('eliides_print_label_dpd_parcel_barcode', $barcodes, $order_id);

                $request = array(
                    'barcode' => implode('|', $barcodes),
                    'format' => eliides_arr_get($dpd, ['format']),
                );

                if (eliides_arr_get($dpd, ['username'])) {
                    $request['username'] = eliides_arr_get($dpd, ['username']);
                }

                if (eliides_arr_get($dpd, ['password'])) {
                    $request['password'] = eliides_arr_get($dpd, ['password']);
                }

                $data = $this->sendRequest('print-label', $request);

                $pdf = base64_decode($data['data']);

                header("Content-type:application/pdf");
                header("Content-Disposition:attachment;filename=pakisilt_$order_id.pdf");
                echo $pdf;
                exit;
            }

			public function send_to_server_action($order) {
				$order_id = absint($_GET['order_id']);

				$this->send_order_to_server_final($order_id);

				wp_safe_redirect(wp_get_referer() ? wp_get_referer() : admin_url('edit.php?post_type=shop_order') );
				exit;
			}

			public function send_to_server_btn($actions, $order) {

				$method_id = get_post_meta($order->get_id(), self::SHIPPING_METHOD, true);

				if ($method_id !== $this->id) {
					return $actions;
				}

				if ($order) {
					if (!get_post_meta($order->get_id(), self::PACKAGE_BARCODE, true)) {
						$actions[self::SEND_TO_SERVER] = array(
							'action' => self::SEND_TO_SERVER,
							'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::SEND_TO_SERVER . '&order_id=' . $order->get_id()), 'eliides-dpd-parcel-send'),
							'name' => __('Saada serverisse', ELIIDES_TD)
						);
					}
					else {
						$actions[self::PRINT_LABEL] = array(
							'action' => self::PRINT_LABEL,
							'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::PRINT_LABEL . '&order_id=' . $order->get_id()), 'eliides-dpd-parcel-print'),
							'name' => __('Prindi pakisilt', ELIIDES_TD)
						);
					}
				}

				return $actions;

			}

            public function send_order_to_server_final($order_id) {
                if (get_post_meta($order_id, self::PACKAGE_BARCODE, true)) {
                    return;
                }

                $method_id = get_post_meta($order_id, self::SHIPPING_METHOD, true);

                if ($method_id !== $this->id) {
                    return;
                }

				$parcel = get_post_meta($order_id, self::PARCEL, true);
				if (!$order = wc_get_order($order_id)) {
                    return;
                }

				if ($parcel && $order) {

					$dpd = get_option('veebiekspert_module_dpd_parcel_params');
                    $dpd = apply_filters('eliides_dpd_parcel_options', $dpd, $order_id);

					$firstname = $order->get_billing_first_name();
					$lastname = $order->get_billing_last_name();

					if (!empty($order->get_shipping_first_name()) && !empty($order->get_shipping_last_name())) {
						$firstname = $order->get_shipping_first_name();
						$lastname = $order->get_shipping_last_name();
					}

					if ($order->get_shipping_address_1()) {
					    $street = implode(', ', array_filter(array($order->get_shipping_address_1(), $order->get_shipping_address_2())));
                    }
					else {
                        $street = implode(', ', array_filter(array($order->get_billing_address_1(), $order->get_billing_address_2())));
                    }

					$name = trim(implode(' ', array($firstname, $lastname)));

					$phone = $order->get_billing_phone();
					$email = $order->get_billing_email();

					$size = get_post_meta($order_id, self::PARCEL_SIZE, true);
					if (empty($size)) {
						$size = 'xs';
					}

                    $shop_weight_unit         = get_option( 'woocommerce_weight_unit' );
                    $product_weight           = 0;
                    $total_order_quantity     = 0;
                    $total_different_products = 0;

                    if ( $shop_weight_unit === 'oz' ) {
                        $divider = 35.274;
                    } elseif ( $shop_weight_unit === 'lbs' ) {
                        $divider = 2.20462;
                    } elseif ( $shop_weight_unit === 'g' ) {
                        $divider = 1000;
                    } else {
                        $divider = 1;
                    }

                    foreach ($order->get_items() as $product ) {
                        $product_data = $product->get_product();
                        $weight = $product_data->get_weight();
                        if($weight >= 0){
                            $product_weight += ($weight / $divider) * $product->get_quantity();
                        } else{
                            $product_weight += (1.0 / $divider) * $product->get_quantity();
                        }
                        $total_order_quantity += $product->get_quantity();
                        $total_different_products += 1;
                    }

                    $request = array(
                        'reference' => $order_id,
                        'size' => $size,
                        'notes' => $order->get_customer_note(),
                        'recipient' => array(
                            'name' => $name,
                            'company_name' => $order->get_shipping_company() ? $order->get_shipping_company() : $order->get_billing_company(),
                            'phone' => $phone,
                            'email' => $email,
                            'street' => $street,
                            'zipcode' => $order->get_shipping_postcode() ? $order->get_shipping_postcode() : $order->get_billing_postcode(),
                            'country' => $order->get_shipping_country() ? $order->get_shipping_country() : $order->get_billing_country(),
                        ),
                        'weight' => $product_weight,
                        'destination' => array(
                            'parcel' => $parcel,

                        ),
                    );

                    if (eliides_arr_get($dpd, ['username'])) {
                        $request['username'] = eliides_arr_get($dpd, ['username']);
                    }

                    if (eliides_arr_get($dpd, ['password'])) {
                        $request['password'] = eliides_arr_get($dpd, ['password']);
                    }

					$data = $this->sendRequest('send-package', $request);

                    if (eliides_arr_get($data, 'status') == true) {
                        update_post_meta($order_id, self::PACKAGE_BARCODE, eliides_arr_get($data, ['data', 'barcodes']));

                        do_action('eliides_after_send_package_dpd_parcel', eliides_arr_get($data, ['data', 'barcodes']), $order_id, $dpd);

                        $barcodes = [];
                        foreach (eliides_arr_get($data, ['data', 'barcodes']) as $barcode) {
                            $barcodes[] = $barcode;
                            $message = sprintf( __( 'DPD jälgimiskood: %s', ELIIDES_TD ), $barcode);
                            $order->add_order_note( $message, true, true );
                        }

                        if ($email = eliides_arr_get($dpd, 'send_pdf_copy')) {

                            $pdfResponse = $this->sendRequest('print-label', array(
                                'barcode' => implode('|', $barcodes),
                                'format' => eliides_arr_get($dpd, ['format']),
                            ));

                            $pdf = base64_decode($pdfResponse['data']);
                            $dest = VE_ABS_PATH . 'tmp/' . uniqid() . '.pdf';
                            file_put_contents($dest, $pdf);
                            eliides_send_email_with_attachment($email, 'Pakisilt tellimusele #' . $order_id, '', $dest);
                            unlink($dest);
                        }


                    }
                    else {
                        $order->add_order_note(eliides_arr_get($data, ['data', 'errors']));
                    }
				}
			}

			public function process_shop_order_meta($post_id, $post) {

				if (isset($_POST['change_eliides_pickup_location'])) {

					if (!$order = wc_get_order($post_id)) {
                        return;
                    }

					$country = Veebiekspert_Modules()->getOrderShippingCountry($order);

					$oldParcel = get_post_meta($post_id, self::PARCEL, true);

					if ($parcel = $this->getParcel($_POST['change_eliides_pickup_location'], $country)) {

						if (eliides_arr_get($oldParcel, ['parcelshop_id']) !== eliides_arr_get($parcel, ['parcelshop_id'])) {

							$old = eliides_arr_get($oldParcel, ['company']);
							$new = eliides_arr_get($parcel, ['company']);

							update_post_meta($post_id, self::PARCEL, $parcel);
							$order->add_order_note(sprintf(__("Pakiautomaat vahetati: \nAlgne: %s \nUus: %s", ELIIDES_TD), $old, $new));

						}

					}

				}

			}

			public function admin_order_pickup_location() {
				global $post;

                if (empty($post)) {
                    return;
                }

				if (!$order = wc_get_order($post->ID)) {
                    return;
                }

				$country = Veebiekspert_Modules()->getOrderShippingCountry($order);

				$method_id = get_post_meta($order->get_id(), self::SHIPPING_METHOD, true);
				$currentParcel = get_post_meta($order->get_id(), self::PARCEL, true);

				if ($method_id == $this->id) {

					$parcels = $this->getParcels($country);

					$groups = array();

					foreach ($parcels as $parcel) {
						$groups[eliides_arr_get($parcel, 'city')][] = $parcel;
					}

					ksort($groups);

					?>
					<div class="eliides_pickup_location">
						<div><h3><?php _e('Valitud pakiautomaat', ELIIDES_TD); ?></h3></div>
						<div><span style="color: #999;"><?php echo $this->getParcelFullTitle($order); ?></span> <a href="#" onclick="jQuery('#eliides_pickup_location-change').show(); return false;"><?php _e('Muuda', ELIIDES_TD); ?></a></div>

						<div id="eliides_pickup_location-change" style="display: none; margin-top: 15px;">
							<select name="change_eliides_pickup_location">
								<option value=""><?php _e('Vali pakiautomaat', ELIIDES_TD); ?></option>
								<?php foreach ($groups as $city => $items): ?>
								<optgroup label="<?php echo esc_html($city); ?>">
									<?php foreach ((array) $items as $item): ?>
									<option value="<?php echo eliides_arr_get($item, 'parcelshop_id'); ?>"<?php if (eliides_arr_get($item, 'parcelshop_id') == eliides_arr_get($currentParcel, 'parcelshop_id')): ?> selected<?php endif; ?>><?php echo esc_html(eliides_arr_get($item, 'company')); ?></option>
									<?php endforeach; ?>
								</optgroup>
								<?php endforeach; ?>
							</select>
						</div>
					</div>
					<?php

				}

			}

			public function getParcelFullTitle($order) {

				$method_id = get_post_meta($order->get_id(), self::SHIPPING_METHOD, true);

				if ($method_id == $this->id) {
					$parcel = get_post_meta($order->get_id(), self::PARCEL, true);

					if ($parcel) {
						return $this->method_title . ' (' . eliides_arr_get($parcel, 'city') . ', ' . eliides_arr_get($parcel, 'company') . ')';
					}
				}

				return false;
			}

			public function alter_shipping_name_in_totals($labels, $order = null) {
				if ($order && $order->get_id()) {

					if ($title = $this->getParcelFullTitle($order)) {
						return $title;
					}
				}
				return $labels;
			}

            public function woocommerce_checkout_create_order(\WC_Order $order, $data) {
                if (!in_array($this->id, (array) _wp_array_get($data, ['shipping_method'], []))) {
                    return;
                }

                if (!$shippingCountry = eliides_arr_get($data, ['shipping_country'])) {
                    $shippingCountry = eliides_arr_get($data, ['billing_country']);
                }
                if (empty($shippingCountry)) {
                    return;
                }

                $parcel = $this->getParcel($_POST['eliides_dpd_parcel_location'], $shippingCountry);

                if ($parcel) {
                    WC()->session->set('_eliides_dpd_parcel_location', eliides_arr_get($parcel, 'parcelshop_id'));
                    $order->add_meta_data(self::PARCEL, eliides_sanitize_text_or_array_field($parcel), true);
                    $order->add_meta_data(self::SHIPPING_METHOD, $this->id, true);

                    $size = 'xs';
                    if (WC()->session->get('_eliides_dpd_parcel_size')) {
                        $size = WC()->session->get('_eliides_dpd_parcel_size');
                    }
                    if (empty($size)) {
                        $size = 'xs';
                    }

                    $order->add_meta_data(self::PARCEL_SIZE, eliides_sanitize_text_or_array_field($size), true);

                }
			}

			public function after_checkout_validation() {

				if (in_array($this->id, (array) $_POST['shipping_method'])) {

					if (!isset($_POST['eliides_dpd_parcel_location']) || empty($_POST['eliides_dpd_parcel_location'])) {
						wc_add_notice(__('Pakiautomaat puudub', ELIIDES_TD), 'error');
						WC()->session->set('_eliides_dpd_parcel_location', '');
						return;
					}

					$shippingCountry = eliides_arr_get(WC()->session->get('customer'), 'shipping_country');

					if (!$parcel = $this->getParcel($_POST['eliides_dpd_parcel_location'], $shippingCountry)) {
						wc_add_notice(__('Tundmatu pakiautomaat', ELIIDES_TD), 'error');
                        WC()->session->set('_eliides_dpd_parcel_location', '');
						return;
					}

				}
			}

			public function pickup_location() {

				$chosenMethods = WC()->session->get('chosen_shipping_methods');

				if (!in_array($this->id, (array) $chosenMethods)) {
					return false;
				}

                $dpd = (array) get_option('veebiekspert_module_dpd_parcel_params');

				$shippingCountry = eliides_arr_get(WC()->session->get('customer'), ['shipping_country']);

				$parcels = $this->getParcels($shippingCountry);

				$groups = array();

				foreach ($parcels as $parcel) {
					$groups[eliides_arr_get($parcel, 'city')][] = $parcel;
				}

				ksort($groups);

				$current = WC()->session->get('_eliides_dpd_parcel_location');
				?>
                <tr class="dpd_parcel-parcel-shipping-row">
					<td colspan="2" class="eliides-chosen-wrapper eliides-dpd-parcel-chosen">
                        <div style="padding-bottom: 10px;"><?php _e('Vali pakiautomaat', ELIIDES_TD); ?></div>
                        <div class="eliides-desktop-chosen">
                            <select class="chosen-select-parcel" id="eliides-dpd_parcel-parcel-location" name="eliides_dpd_parcel_location">
                                <option value=""><?php _e('Vali pakiautomaat', ELIIDES_TD); ?></option>
                                <?php foreach ($groups as $city => $items): ?>
                                    <optgroup label="<?php echo esc_html($city); ?>">
                                        <?php foreach ($items as $item): ?>
                                            <option value="<?php echo eliides_arr_get($item, 'parcelshop_id'); ?>"<?php if (eliides_arr_get($item, 'parcelshop_id') == $current): ?> selected<?php endif; ?>><?php echo esc_html(eliides_arr_get($item, 'company')); ?></option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <?php if (eliides_arr_get($dpd, ['classic_mobile_view']) !== 'yes'): ?>
                        <div class="eliides-mobile-chosen">
                            <div class="eliides-select-btn"><?php _e('Vali pakiautomaat', ELIIDES_TD); ?></div>
                            <div class="eliides-mobile-chosen-popup">
                                <div class="eliides-mobile-chosen-popup-header">
                                    <input type="text" />
                                    <span>&times;</span>
                                    <div style="clear: both;"></div>
                                </div>
                                <div class="eliides-mobile-chosen-popup-body">
                                    <?php foreach ((array) $groups as $city => $items): ?>
                                        <div class="eliides-mobile-chosen-popup-group">
                                            <div class="eliides-mobile-chosen-popup-group-parent">
                                                <?php echo esc_html($city); ?>
                                            </div>
                                            <div class="eliides-mobile-chosen-popup-group-items">
                                                <?php foreach ((array) $items as $item): ?>
                                                    <div data-input-value="<?php echo eliides_arr_get($item, 'parcelshop_id'); ?>"><?php echo esc_html(eliides_arr_get($item, 'company')); ?></div>
                                                <?php endforeach; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                        <script type="text/javascript">
                          jQuery('.chosen-select-parcel[name="eliides_dpd_parcel_location"]').chosen({
                            width: '100%'
                          });
                          jQuery(window).resize(function() {
                            if (jQuery(window).width() >= 769) {
                              jQuery('.eliides-dpd-parcel-chosen .eliides-mobile-chosen').hide();
                              jQuery('.eliides-dpd-parcel-chosen .eliides-desktop-chosen').show();
                            } else {
                              jQuery('.eliides-dpd-parcel-chosen .eliides-mobile-chosen').show();
                              jQuery('.eliides-dpd-parcel-chosen .eliides-desktop-chosen').hide();

                              jQuery('.eliides-chosen-wrapper.eliides-dpd-parcel-chosen').each(function() {
                                var eliides_popup = jQuery(this).find('.eliides-mobile-chosen-popup');
                                jQuery(this).find('.eliides-select-btn').click(function() {
                                  eliides_popup.show();
                                  eliides_popup.find('input').val('').keyup().focus();
                                });
                                eliides_popup.find('.eliides-mobile-chosen-popup-header span').click(function() {
                                  eliides_popup.hide();
                                  eliides_popup.find('input').val('');
                                });
                                var eliides_header_height = eliides_popup.find('.eliides-mobile-chosen-popup-header').outerHeight();
                                eliides_popup.find('.eliides-mobile-chosen-popup-body').css('height', (jQuery(window).height() - 30 - eliides_header_height) + 'px');
                                eliides_popup.find('input').keyup(function() {
                                  var val = jQuery(this).val();
                                  if (!val) {
                                    eliides_popup.find('.eliides-mobile-chosen-popup-group').show();
                                    eliides_popup.find('.eliides-mobile-chosen-popup-group-items div').show();
                                  } else {
                                    var search_term = val.toLowerCase();
                                    eliides_popup.find('.eliides-mobile-chosen-popup-group').each(function() {
                                      var groupItemFound = false;
                                      jQuery(this).find('.eliides-mobile-chosen-popup-group-items div').each(function() {
                                        var str = jQuery(this).html();
                                        if (str.toLowerCase().indexOf(search_term) >= 0) {
                                          groupItemFound = true;
                                          jQuery(this).show();
                                        } else {
                                          jQuery(this).hide();
                                        }
                                      });
                                      if (groupItemFound) {
                                        jQuery(this).show();
                                      } else {
                                        jQuery(this).hide();
                                      }
                                    });
                                  }
                                });
                                eliides_popup.find('.eliides-mobile-chosen-popup-group-items div').click(function() {
                                  jQuery(this).closest('.eliides-chosen-wrapper').find('.chosen-select-parcel').val(jQuery(this).attr('data-input-value'));
                                  jQuery(this).closest('.eliides-chosen-wrapper').find('.chosen-select-parcel').change();
                                  jQuery(this).closest('.eliides-chosen-wrapper').find('.chosen-select-parcel').trigger("chosen:updated");

                                  eliides_popup.hide();
                                  eliides_popup.find('input').val('');
                                });
                                jQuery('.chosen-select-parcel').change(function() {
                                  jQuery(this).closest('.eliides-chosen-wrapper').find('.eliides-select-btn').html(jQuery(this).find('option:selected').text());
                                });
                                jQuery('.chosen-select-parcel').change();
                              });
                            }

                          });
                          jQuery(window).resize();
                        </script>
                        <style>
                            .eliides-mobile-chosen-popup-header input {
                                width: calc(100% - 80px);
                                float: left;
                            }
                            .eliides-mobile-chosen-popup-header span {
                                float: right;
                                display: inline-block;
                                font-size: 30px;
                                margin-right: 20px;
                            }
                            .eliides-mobile-chosen-popup {
                                display: none;
                                position: fixed;
                                top: 0;
                                left: 0;
                                z-index: 999;
                                background: #fff;
                                width: 100%;
                                height: 100%;
                            }
                            .eliides-mobile-chosen-popup-header {
                                padding: 5px;
                            }
                            .eliides-mobile-chosen-popup-body {
                                overflow-y: scroll;
                            }
                            .eliides-mobile-chosen-popup-group {
                                margin-top: 10px;
                                font-size: 14px;
                            }
                            .eliides-mobile-chosen-popup-group-parent {
                                font-weight: bold;
                                padding: 10px 10px;
                            }
                            .eliides-mobile-chosen-popup-group-items div {
                                border-bottom: 1px solid #efefef;
                                padding: 10px 10px;
                            }
                            .eliides-mobile-chosen .eliides-select-btn {
                                border: 1px solid #ccc;
                                padding: 7px 10px;
                                background: #fff;
                                position: relative;
                            }
                            .eliides-mobile-chosen .eliides-select-btn:after {
                                position: absolute;
                                display: inline-block;
                                right: 5px;
                                top: 10px;
                                width: 30px;
                                height: 30px;
                                background-image: url("data:image/svg+xml;charset=UTF-8,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2212%22%20height%3D%2212%22%20viewBox%3D%220%200%2012%2012%22%3E%3Ctitle%3Edown-arrow%3C%2Ftitle%3E%3Cg%20fill%3D%22%23000000%22%3E%3Cpath%20d%3D%22M10.293%2C3.293%2C6%2C7.586%2C1.707%2C3.293A1%2C1%2C0%2C0%2C0%2C.293%2C4.707l5%2C5a1%2C1%2C0%2C0%2C0%2C1.414%2C0l5-5a1%2C1%2C0%2C1%2C0-1.414-1.414Z%22%20fill%3D%22%23000000%22%3E%3C%2Fpath%3E%3C%2Fg%3E%3C%2Fsvg%3E");
                                background-repeat: no-repeat;
                                background-position: top center;
                                content: "";
                            }
                        </style>
                    <?php else: ?>
                        <script type="text/javascript">
                        jQuery('.chosen-select-parcel[name="eliides_dpd_parcel_location"]').chosen({
                          width: '100%'
                        });
                        </script>
                    <?php endif; ?>
                        <style>
                            .eliides-chosen-wrapper .chosen-container {
                                font-size: 15px;
                            }
                            .eliides-chosen-wrapper {
                                text-align: left !important;
                            }
                            .eliides-chosen-wrapper a.chosen-single {
                                height: 34px !important;
                                line-height: 34px !important;
                            }
                        </style>
                    </td>
				</tr>
				<?php
			}

			public function add_shipping_method( $methods ) {
				$methods[$this->id] = $this;
				return $methods;
			}

			public function getParcel($placeId, $country) {
				$parcels = $this->getParcels($country);
                if (!is_array($parcels)) {
                    return false;
                }
				foreach ($parcels as $parcel) {
                    if (!isset($parcel['parcelshop_id'])) {
                        continue;
                    }
					if ($parcel['parcelshop_id'] == $placeId) {
						return (array) $parcel;
					}
				}
				return false;
			}

			public function getParcels($country = 'EE') {
				if (isset($this->_parcels[$country])) {
					return (array) $this->_parcels[$country];
				}
				$res = $this->sendRequest('get-parcels', array('country' => $country));
				$this->_parcels[$country] = (array) eliides_arr_get($res, 'data');

				return (array) eliides_arr_get($res, 'data');
			}

			public function sendRequest($action, $params = array()) {
				$apiKey = get_option('veebiekspert_module_dpd_parcel_api_key');
                $dpd = get_option('veebiekspert_module_dpd_parcel_params', []);

				$params['software'] = 'dpd_parcel';

                if (!eliides_arr_get($params, ['username'])) {
                    $params['username'] = eliides_arr_get($dpd, ['username']);
                }

                if (!eliides_arr_get($params, ['password'])) {
                    $params['password'] = eliides_arr_get($dpd, ['password']);
                }

                $params['is_test'] = eliides_arr_get($dpd, ['is_test']);

				return Veebiekspert_Modules()->getApi()->sendRequest($apiKey, 'dpd-parcel', $action, $params);
			}


			/**
			 * This function is used to calculate the shipping cost. Within this function we can check for weights, dimensions and other parameters.
			 *
			 * @access public
			 * @param mixed $package
			 * @return void
			 */
			public function calculate_shipping( $package = array() ) {

                if (!apply_filters('veebiekspert_shipping_method_is_active', true, 'dpd_parcel')) {
                    return false;
                }
                $veebiekspert_active_module = get_option('veebiekspert_active_module');

                if (!in_array('dpd_parcel', (array) $veebiekspert_active_module)) {
                    return false;
                }

				$country = strtolower(eliides_arr_get($package, ['destination', 'country']));

				$dpd = get_option('veebiekspert_module_dpd_parcel_params', []);
                $prices = eliides_arr_get($dpd, ['prices', strtoupper($country)]);
                if (empty($prices)) {
                    return false;
                }
				$items = array();

				$cartTotal = 0;
                $hasFreeShipping = false;

                $unit = get_option( 'woocommerce_dimension_unit' );

                $unitX = 1;
                if ($unit == 'cm') {
                    $unitX = 10;
                }
                else if ($unit == 'm') {
                    $unitX = 1000;
                }

				foreach ($package['contents'] as $content) {
					$cartTotal += $content['line_subtotal'];
					$product = $content['data'];
					if ($product->needs_shipping()) {

                        $productId = $product->get_id();
                        if (get_post_meta($productId, '_parcel_do_not_fit', true)) {
                            return false;
                        }
                        if ($parentId = $product->get_parent_id()) {
                            $productId = $parentId;
                        }
                        if (get_post_meta($productId, '_no_shipping_cost', true) == 'yes') {
                            $hasFreeShipping = true;
                        }

						for ($qty = 1; $qty <= $content['quantity']; $qty ++) {

							if ($product->get_height() > 0 || $product->get_width() > 0 || $product->get_length() > 0) {
							    $length = $width = $weight = $height = 0;
							    if ($product->get_length()) {
							        $length = $product->get_length();
                                }
							    if ($product->get_width()) {
                                    $width = $product->get_width();
                                }
							    if ($product->get_height()) {
                                    $height = $product->get_height();
                                }
							    if ($product->get_weight()) {
							        $weight = (int) $product->get_weight();
                                }
								$items[] = array(
									'measures' => array(
                                        $length * $unitX,
                                        $width * $unitX,
                                        $height * $unitX,
                                        $weight
									),
								);
							}

						}
					}
				}

				$size = '';



				$hasCoupon = false;

				if (WC()->cart->applied_coupons) {
					foreach (WC()->cart->applied_coupons as $code) {
						$coupon = new WC_Coupon($code);
                        if ($coupon->is_valid_for_cart() && $coupon->get_free_shipping()) {
							$hasCoupon = true;
							break;
						}
					}
				}

				if (!empty($items)) {

					$data = $this->sendRequest('get-parcel-size', array(
						'items' => $items,
                        'unit' => get_option( 'woocommerce_dimension_unit' )
					));

					if (isset($data['data'])) {
						if (isset($prices[$data['data']])) {
							$size = $data['data'];
						}
					}

					if (empty($size)) {
					    return false;
                    }

				}
				else {
                    $size = 'xs';
                }

				if ($hasFreeShipping || $hasCoupon || (strlen($prices['free_from']) > 0 && $prices['free_from'] <= $cartTotal)) {

					$price = 0;

				}
				else {



					$price = $prices[$size];

				}

				WC()->session->_eliides_dpd_parcel_size = $size;

				$rate = array(
					'id' => $this->id,
					'label' => $this->title,
					'cost' =>  $price
				);

				$this->add_rate( $rate );
			}


		}

    endif;

    $veebiekspert_active_module = get_option('veebiekspert_active_module');

    new Veebiekspert_Transport_DpdParcel();


}

add_action('plugins_loaded', 'eliides_init_dpd_parcel');


