<?php


if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

function eliides_init_omniva() {

	if ( ! class_exists( 'Veebiekspert_Transport_Omniva' ) && class_exists( 'WC_Shipping_Method' ) ) :

		class Veebiekspert_Transport_Omniva extends WC_Shipping_Method {

			const SHIPPING_METHOD = '_eliides_shipping_method';
			const SEND_TO_SERVER = 'omniva_send_to_server';
			const PACKAGE_BARCODE = '_eliides_omniva_barcode';
			const PRINT_LABEL = 'omniva_print_label';

			protected $_parcels = array();

			public function __construct() {

				$this->id                 = 'eliides_omniva';

				$this->method_title       = __('Omniva', ELIIDES_TD);
				$this->method_description = null;

				$this->title       = __('Omniva', ELIIDES_TD);

				add_filter( 'woocommerce_shipping_methods', array(&$this, 'add_shipping_method'));
                add_filter( 'eliides_omniva_services_filter', array($this, 'eliides_omniva_services_filter'));

				Veebiekspert_Modules()->setOmniva($this);

                $this->init();

                $veebiekspert_active_module = get_option('veebiekspert_active_module');

                if (in_array('omniva', (array) $veebiekspert_active_module)) {
                    $options = (array) get_option('veebiekspert_module_omniva_params');
                    if (eliides_arr_get($options, 'add_package_tracking_details_to_email') == 'yes') {
                        add_action('woocommerce_email_order_details', array($this, 'woocommerce_email_order_details'), 10, 4);
                    }
                }

                add_action('manage_shop_order_posts_custom_column', array($this, 'manage_shop_order_posts_custom_column'), 50, 2);
                add_action('woocommerce_shop_order_list_table_custom_column', array($this, 'woocommerce_shop_order_list_table_custom_column'), 50, 2);

                add_action('woocommerce_checkout_update_order_meta', array($this, 'checkout_update_order_meta'), 10, 2);

				if (is_admin()) {
					add_filter('woocommerce_admin_order_actions', array($this, 'send_to_server_btn'), 10, 2);

					add_action('wp_ajax_' . self::SEND_TO_SERVER, array($this, 'send_to_server_action'));
					add_action('wp_ajax_' . self::PRINT_LABEL, array($this, 'print_label_action'));

                    add_action('admin_footer', array($this, 'custom_bulk_admin_footer'));
                    add_action('load-edit.php', array($this, 'bulk_action'));
				}
                if (eliides_is_module_active('omniva')) {
                    add_action('woocommerce_order_status_on-hold', array($this, 'check_if_send_to_server_automatic'));
                    add_action('woocommerce_order_status_processing', array($this, 'check_if_send_to_server_automatic'));
                    add_action('woocommerce_order_status_completed', array($this, 'check_if_send_to_server_automatic'));
                }

			}

            public function manage_shop_order_posts_custom_column($column_name, $order_id) {
                if ($column_name == 'shipping_address') {
                    if (get_post_meta($order_id, self::SHIPPING_METHOD, true) == $this->id) {
                        $barcodes = (array) get_post_meta($order_id, self::PACKAGE_BARCODE, true);
                        foreach ($barcodes as $barcode) {
                            $link = '<a href="' . $this->getTrackingLink($barcode) . '" target="_blank"> ' . esc_html($barcode) . '</a>';
                            echo '<div style="font-weight: bold;">Jälgimiskood: ' . $link . '</div>';
                        }

                    }
                }
            }

            public function woocommerce_shop_order_list_table_custom_column($column_name, \WC_Order $order) {
                if ($column_name == 'shipping_address') {
                    if (get_post_meta($order->get_id(), self::SHIPPING_METHOD, true) == $this->id) {
                        $barcodes = (array) get_post_meta($order->get_id(), self::PACKAGE_BARCODE, true);
                        foreach ($barcodes as $barcode) {
                            $link = '<a href="' . $this->getTrackingLink($barcode) . '" target="_blank"> ' . esc_html($barcode) . '</a>';
                            echo '<div style="font-weight: bold;">Jälgimiskood: ' . $link . '</div>';
                        }

                    }
                }
            }

            public function getTrackingLink($code) {
                return 'https://www.omniva.ee/private/track_and_trace/?barcode=' . $code;
            }

            public function woocommerce_email_order_details( $order, $sent_to_admin, $plain_text, $email ) {

                if ( 'customer_completed_order' == $email->id ) {
                    $order_id = $order->get_id();

                    $tracking_number = null;
                    $tracking_url = null;
                    $tracking_provider = null;

                    if ($code = get_post_meta($order_id, self::PACKAGE_BARCODE, true)) {
                        if (is_array($code)) {
                            $code = array_shift($code);
                        }
                        $tracking_number = $code;
                        $tracking_provider = $this->title;
                        $tracking_url = $this->getTrackingLink($code);
                    }

                    if ( empty( $tracking_number ) || empty( $tracking_url ) ) {
                        return;
                    }

                    if ( $plain_text ) {
                        printf( __("\nSinu tellimus jälgimiskoodiga %s on edastatud kullerile %s. Pakki saab jälgida aadressilt %s.\n", ELIIDES_TD), esc_html( $tracking_number ), $tracking_provider, esc_url( $tracking_url, array( 'http', 'https' ) ) );
                    }
                    else {
                        printf( __('<p>Sinu tellimus jälgimiskoodiga <strong>%s</strong> on edastatud kullerile <strong>%s</strong>. Pakki saab jälgida aadressilt <strong><a href="%s">%s</a></strong>.</p>', ELIIDES_TD), esc_html( $tracking_number ), $tracking_provider, esc_url( $tracking_url, array( 'http', 'https' ) ), esc_url( $tracking_url, array( 'http', 'https' ) ) );
                    }
                }
            }

            function init() {
                // Load the settings API
                $this->init_form_fields();
                $this->init_settings();

                add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );
            }

            function get_admin_options_html() {
                $veebiekspert_active_module = (array) get_option('veebiekspert_active_module');
                $countries = Veebiekspert_Modules()->getCountries();
                $eu_countries = Veebiekspert_Modules()->getEuCountries();
                ?>
                <div class="veebiekspert-setting-block">

                    <?php
                    $omniva = (array) get_option('veebiekspert_module_omniva_params');
                    ?>

                    <input type="hidden" name="is_module_active" value="0" />
                    <h2><label><input type="checkbox" name="is_module_active"<?php if (in_array('omniva', $veebiekspert_active_module)): ?> checked<?php endif; ?> value="1" /> Aktiivne</label></h2>

                    <div class="settings-block-inner">

                        <div class="ve-form-group">
                            <label>E-liides litsentsi võti</label>
                            <input type="text" id="veebiekspert_module_omniva_api_key" name="veebiekspert_module_omniva_api_key" value="<?php echo get_option('veebiekspert_module_omniva_api_key'); ?>" />
                            <a href="https://www.e-liides.ee" target="_blank">Registreeri võti (7 päeva tasuta)</a>
                        </div>

                        <div class="ve-form-group">
                            <label>Omniva kasutaja</label>
                            <input type="text" name="veebiekspert_module_omniva_params[username]" value="<?php echo @esc_html(eliides_arr_get($omniva, ['username'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Omniva parool</label>
                            <input type="password" name="veebiekspert_module_omniva_params[password]" value="<?php echo eliides_arr_get($omniva, ['password']); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Teenuse tüüp</label>

                            <?php

                            $options = array(
                                'businessToClientMsg' => 'businessToClientMsg - Pakiandmed saadetakse Omnivasse ja saate automaatselt pakisildi e-poest trükkida',
                                'preSendMsg' => 'preSendMsg - Pakiandmed saadetakse Omniva serverisse. Omniva iseteeninduses peab pakiandmed eraldi kinnitama',
                            );

                            $selected = eliides_arr_get($omniva, ['request_type']);
                            ?>

                            <select name="veebiekspert_module_omniva_params[request_type]">
                                <?php foreach ($options as $k => $i): ?>
                                    <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>



                        <div class="ve-form-group">
                            <label>Mitme pakisildi printimine</label>

                            <?php

                            $options = array(
                                'combine' => 'Paiguta pakisildid ühele lehele',
                                'separate' => 'Iga pakisilt eraldi lehele',
                            );

                            $selected = eliides_arr_get($omniva, ['separate_pages']);
                            ?>

                            <select name="veebiekspert_module_omniva_params[separate_pages]">
                                <?php foreach ($options as $k => $i): ?>
                                    <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Aktiivne keskkond</label>

                            <?php

                            $options = array(
                                '0' => 'Live ehk reaalne keskkond',
                                '1' => 'Test ehk süsteemi testimine',
                            );

                            $selected = (int) eliides_arr_get($omniva, ['is_test']);
                            $selectedCountry = !isset($omniva['sender']['country']) ? 'EE' : $omniva['sender']['country'];

                            ?>

                            <select name="veebiekspert_module_omniva_params[is_test]">
                                <?php foreach ($options as $k => $i): ?>
                                    <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Nimi tagastusaadressil</label>
                            <input type="text" name="veebiekspert_module_omniva_params[sender][name]" value="<?php echo @esc_html(eliides_arr_get($omniva, ['sender', 'name'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Telefon tagastusaadressil</label>
                            <input type="text" name="veebiekspert_module_omniva_params[sender][phone]" value="<?php echo @esc_html(eliides_arr_get($omniva, ['sender','phone'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>E-mail tagastusaadressil</label>
                            <input type="text" name="veebiekspert_module_omniva_params[sender][email]" value="<?php echo @esc_html(eliides_arr_get($omniva, ['sender','email'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Riik tagastusaadressil</label>
                            <select name="veebiekspert_module_omniva_params[sender][country]">
                                <?php foreach ($countries as $countryCode => $name): ?>
                                    <option value="<?php echo @esc_html($countryCode); ?>"<?php if ($countryCode == $selectedCountry): ?> selected<?php endif; ?>><?php echo @esc_html($name); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Linn ja maakond tagastusaadressil</label>
                            <input type="text" name="veebiekspert_module_omniva_params[sender][city]" value="<?php echo @esc_html(eliides_arr_get($omniva, ['sender','city'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Tänav tagastusaadressil</label>
                            <input type="text" name="veebiekspert_module_omniva_params[sender][street]" value="<?php echo @esc_html(eliides_arr_get($omniva, ['sender','street'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Postiindeks tagastusaadressil</label>
                            <input type="text" name="veebiekspert_module_omniva_params[sender][zip]" value="<?php echo @esc_html(eliides_arr_get($omniva, ['sender','zip'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Paki andmed saadetakse automaatselt</label>

                            <?php

                            $options = array(
                                '' => 'Automaatselt ei saadeta, pakisildi saab ainult käsitsi tellimuste nimekirjast',
                                'woocommerce_order_status_on-hold' => 'Kui tellimus on vähemalt ootel olekus',
                                'woocommerce_order_status_processing' => 'Kui tellimus on vähemalt töötluses olekus',
                                'woocommerce_order_status_completed' => 'Kui tellimus on täidetud',
                            );

                            $selected = eliides_arr_get($omniva, ['send_to_server_automatic']);
                            ?>

                            <select name="veebiekspert_module_omniva_params[send_to_server_automatic]">
                                <?php foreach ($options as $k => $i): ?>
                                    <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Muuda tellimuse olek peale pakisildi printimist valitud olekusse</label>

                            <?php
                            $options = array(
                                '' => 'Ei muuda tellimuse olekut',
                            );
                            foreach (wc_get_order_statuses() as $orderStatus => $orderStatusValue) {
                                $options[esc_html(str_replace('wc-', '', $orderStatus))] = esc_html($orderStatusValue);
                            }
                            $selected = eliides_arr_get($omniva, ['mark_order_completed_after_packing_split_print']);
                            ?>

                            <select name="veebiekspert_module_omniva_params[mark_order_completed_after_packing_split_print]">
                                <?php foreach ($options as $k => $i): ?>
                                    <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Lisa paki jälgimiskood ja kulleri info täidetud tellimuse e-mailile kaasa</label>

                            <?php
                            $options = array(
                                'no' => 'Ei lisa',
                                'yes' => 'Lisa e-mailile info kaasa',
                            );
                            $selected = eliides_arr_get($omniva, ['add_package_tracking_details_to_email']);
                            ?>

                            <select name="veebiekspert_module_omniva_params[add_package_tracking_details_to_email]">
                                <?php foreach ($options as $k => $i): ?>
                                    <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Saada pakisildi koopia e-mailile</label>
                            <input type="text" name="veebiekspert_module_omniva_params[send_pdf_copy]" value="<?php echo @esc_html(eliides_arr_get($omniva, ['send_pdf_copy'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Hinnad</label>

                            <?php
                            $defaultPrices = array(
                                'all' => array(
                                    'price' => 6,
                                    'service_code' => 'XN',
                                    'free_from' => '',
                                ),
                            );

                            $prices = eliides_arr_get($omniva, ['prices']);
                            if (empty($prices)) {
                                $prices = $defaultPrices;
                            }
                            ?>

                            <table class="widefat fixed" style="margin-top: 20px;">
                                <thead>
                                <tr>
                                    <th>Riik</th>
                                    <th>Hind km-ta</th>
                                    <th>Tasuta tarne alates EUR, km-ta</th>
                                    <th>Teenuse kood (XN = Omniva veebiteenus)</th>
                                    <th></th>
                                </tr>
                                </thead>
                                <tbody id="omniva-prices-table">
                                <tr>
                                    <td>Kõik ülejäänud riigid</td>
                                    <td><input style="width: 100%;" type="number" step="0.01" name="veebiekspert_module_omniva_params[prices][all][price]" value="<?php echo eliides_number_format(eliides_arr_get($prices, ['all', 'price']), 2, '.', ''); ?>" /></td>
                                    <td><input style="width: 100%;" type="number" step="0.01" name="veebiekspert_module_omniva_params[prices][all][free_from]" value="<?php echo eliides_arr_get($prices, ['all', 'free_from']); ?>" /></td>
                                    <td><input style="width: 100%;" type="text" name="veebiekspert_module_omniva_params[prices][all][service_code]" value="<?php echo @esc_html(eliides_arr_get($prices, ['all', 'service_code'])); ?>" /></td>
                                    <td></td>
                                </tr>
                                <?php foreach ($prices as $country => $countyParams): if ($country == 'all') { continue; } ?>
                                    <tr>
                                        <td><?php echo @esc_html(eliides_arr_get($countries, $country)); ?></td>
                                        <td><input style="width: 100%;" type="number" step="0.01" name="veebiekspert_module_omniva_params[prices][<?php echo $country; ?>][price]" value="<?php echo eliides_number_format(eliides_arr_get($countyParams, 'price'), 2, '.', ''); ?>" /></td>
                                        <td><input style="width: 100%;" type="number" step="0.01" name="veebiekspert_module_omniva_params[prices][<?php echo $country; ?>][free_from]" value="<?php echo eliides_arr_get($countyParams, ['free_from']); ?>" /></td>
                                        <td><input style="width: 100%;" type="text" name="veebiekspert_module_omniva_params[prices][<?php echo $country; ?>][service_code]" value="<?php echo @esc_html(eliides_arr_get($countyParams, ['service_code'])); ?>" /></td>
                                        <td><span style="color: red; cursor: pointer;" onclick="jQuery(this).closest('tr').remove();">Kustuta</span></td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td colspan="5">
                                        <select id="omniva-new-country">
                                            <?php foreach ($countries as $countryCode => $name): ?>
                                                <option value="<?php echo @esc_html($countryCode); ?>"<?php if ($countryCode == $selectedCountry): ?> selected<?php endif; ?>><?php echo @esc_html($name); ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <button class="button" onclick="return addNewOmnivaRow();">Lisa</button>
                                    </td>
                                </tr>
                                </tfoot>
                            </table>

                            <script type="text/javascript">
                                function addNewOmnivaRow() {
                                    var html = jQuery('#new-omniva-row-template').html();

                                    html = html.replace(new RegExp('country_name', 'g'), jQuery('#omniva-new-country option:selected').text());
                                    html = html.replace(new RegExp('country', 'g'), jQuery('#omniva-new-country').val());

                                    jQuery('#omniva-prices-table').append(html);
                                    return false;
                                }
                            </script>

                            <script type="text/template" id="new-omniva-row-template">
                                <tr>
                                    <td>country_name</td>
                                    <td><input style="width: 100%;" type="number" step="0.01" name="veebiekspert_module_omniva_params[prices][country][price]" value="6" /></td>
                                    <td><input style="width: 100%;" type="number" step="0.01" name="veebiekspert_module_omniva_params[prices][country][free_from]" value="" /></td>
                                    <td><input style="width: 100%;" type="text" name="veebiekspert_module_omniva_params[prices][country][service_code]" value="QP" /></td>
                                    <td><span style="color: red; cursor: pointer;" onclick="jQuery(this).closest('tr').remove();">Kustuta</span></td>
                                <tr>
                            </script>

                        </div>

                    </div>

                </div>
                <?php
            }

            public function process_admin_options()
            {
                $this->init_settings();

                $post_data = $this->get_post_data();
                update_option('veebiekspert_module_omniva_api_key', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_omniva_api_key']));
                update_option('veebiekspert_module_omniva_params', $post_data['veebiekspert_module_omniva_params']);

                $activeModules = (array) get_option('veebiekspert_active_module', []);
                $module = 'omniva';

                if (!empty($post_data['is_module_active'])) {
                    if (!in_array($module, $activeModules)) {
                        $activeModules[] = $module;
                        update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
                    }
                }
                else {
                    $key = array_search($module, $activeModules);
                    if (false !== $key) {
                        unset($activeModules[$key]);
                        update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
                    }
                }

            }

            public function check_if_send_to_server_automatic($order_id) {
                $omniva = get_option('veebiekspert_module_omniva_params', []);
                $trigger = eliides_arr_get($omniva, ['send_to_server_automatic']);

                if ($order = wc_get_order($order_id)) {

                    if ($trigger == 'woocommerce_order_status_on-hold') {

                        if ($order->has_status(array('on-hold', 'processing', 'completed'))) {
                            $this->send_order_to_server_final($order_id);
                        }
                    }
                    elseif ($trigger == 'woocommerce_order_status_processing') {

                        if ($order->has_status(array('processing', 'completed'))) {
                            $this->send_order_to_server_final($order_id);
                        }
                    }
                    elseif ($trigger == 'woocommerce_order_status_completed') {

                        if ($order->has_status(array('completed'))) {
                            $this->send_order_to_server_final($order_id);
                        }
                    }

                }

            }

            public function custom_bulk_admin_footer() {
                global $post_type;
                if($post_type == 'shop_order') {
                    ?>
                    <script type="text/javascript">
                        jQuery(document).ready(function() {
                            jQuery('<option>').val('eliides_omniva_send_bulk').text('<?php echo esc_html(__('Trüki Omniva kulleri pakisildid', ELIIDES_TD)); ?>').appendTo('select[name="action"]');
                            jQuery('<option>').val('eliides_omniva_send_bulk').text('<?php echo esc_html(__('Trüki Omniva kulleri pakisildid', ELIIDES_TD)); ?>').appendTo('select[name="action2"]');
                        });
                    </script>
                    <?php
                }
            }

            public function bulk_action() {
                $wp_list_table = _get_list_table( 'WP_Posts_List_Table' );
                $action        = $wp_list_table->current_action();

                if ($action !== 'eliides_omniva_send_bulk') {
                    return false;
                }

                $post_ids = array_map( 'absint', (array) $_REQUEST['post'] );

                $finalBarcodes = array();

                foreach ($post_ids as $order_id) {
                    $this->send_order_to_server_final($order_id);
                    $barcodes = (array) get_post_meta($order_id, self::PACKAGE_BARCODE, true);
                    foreach ($barcodes as $barcode) {
                        $finalBarcodes[] = $barcode;
                    }
                }

                $omniva = get_option('veebiekspert_module_omniva_params');
                $separate_pages = eliides_arr_get($omniva, ['separate_pages']);

                $data = $this->sendRequest('print-label', array(
                    'username' => eliides_arr_get($omniva, 'username'),
                    'password' => eliides_arr_get($omniva, 'password'),
                    'barcodes' => $finalBarcodes,
                    'bulk' => 1,
                    'separate_pages' => $separate_pages == 'separate'
                ));

                $pdf = base64_decode($data['data']);
                $order_ids = implode('_', $post_ids);
                header("Content-type:application/pdf");
                header("Content-Disposition:attachment;filename=pakisilt_$order_ids.pdf");
                echo $pdf;
                exit;
            }

			public function eliides_omniva_services_filter($settings, $orderId = null) {
			    return $settings;
            }

			public function print_label_action($order) {
				$order_id = absint($_GET['order_id']);

				$omniva = get_option('veebiekspert_module_omniva_params');

                if ($newStatus = eliides_arr_get($omniva, ['mark_order_completed_after_packing_split_print'])) {
                    if ($order = wc_get_order($order_id)) {
                        if (!$order->has_status(array($newStatus))) {
                            $order->update_status($newStatus);
                        }
                    }
                }

				$barcodes = (array) get_post_meta($order_id, self::PACKAGE_BARCODE, true);

                $separate_pages = eliides_arr_get($omniva, ['separate_pages']);

				$data = $this->sendRequest('print-label', array(
					'username' => eliides_arr_get($omniva, 'username'),
					'password' => eliides_arr_get($omniva, 'password'),
					'barcodes' => isset($_GET['barcode']) ? $_GET['barcode'] : $barcodes,
                    'separate_pages' => $separate_pages == 'separate'
				));

				if (isset($_GET['barcode'])) {
                    update_post_meta($order_id, sanitize_text_field('printed_barcode_' . $_GET['barcode']), 1);
                }

				$pdf = base64_decode($data['data']);

				header("Content-type:application/pdf");
				header("Content-Disposition:attachment;filename=pakisilt_$order_id.pdf");
				echo $pdf;
				exit;
			}

			public function send_to_server_action($order) {
				$order_id = absint($_GET['order_id']);
				$this->send_order_to_server_final($order_id);

				wp_safe_redirect(wp_get_referer() ? wp_get_referer() : admin_url('edit.php?post_type=shop_order') );
				exit;
			}

			public function send_to_server_btn($actions, $order) {

				$method_id = get_post_meta($order->get_id(), self::SHIPPING_METHOD, true);

				if ($method_id !== $this->id) {
					return $actions;
				}

				if ($order) {
					if (!$barcodes = get_post_meta($order->get_id(), self::PACKAGE_BARCODE, true)) {
						$actions[self::SEND_TO_SERVER] = array(
							'action' => self::SEND_TO_SERVER,
							'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::SEND_TO_SERVER . '&order_id=' . $order->get_id()), 'eliides-itella-send'),
							'name' => __('Saada serverisse', ELIIDES_TD)
						);
					}
					else {
					    if ($barcodeGroups = get_post_meta($order->get_id(), '_barcode_groups', true)) {
					        foreach ($barcodeGroups as $barcodes) {
					            $actions[] = array(
					                'action' => '',
                                    'url' => '#',
                                    'name' => ' | ',
                                );
                                foreach ($barcodes as $barcode) {
                                    $extraClass = get_post_meta($order->get_id(), 'printed_barcode_' . $barcode, true) ? ' printed' : ' not-printed';
                                    $actions[] = array(
                                        'action' => self::PRINT_LABEL . $extraClass,
                                        'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::PRINT_LABEL . '&order_id=' . $order->get_id() . '&barcode=' . $barcode), 'eliides-itella-print'),
                                        'name' => __('Prindi pakisilt', ELIIDES_TD)
                                    );
                                }
                            }
                        }
					    else {
                            foreach ($barcodes as $barcode) {
                                $extraClass = get_post_meta($order->get_id(), 'printed_barcode_' . $barcode, true) ? ' printed' : ' not-printed';
                                $actions[] = array(
                                    'action' => self::PRINT_LABEL . $extraClass,
                                    'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::PRINT_LABEL . '&order_id=' . $order->get_id() . '&barcode=' . $barcode), 'eliides-itella-print'),
                                    'name' => __('Prindi pakisilt', ELIIDES_TD)
                                );
                            }
                        }

					}
				}

				return $actions;

			}

			protected function send_order_to_server_final($order_id) {
				$old = get_post_meta($order_id, self::PACKAGE_BARCODE);


				if (!empty($old)) {
					return;
				}
				if (!$order = wc_get_order($order_id)) {
                    return;
                }

                $method_id = get_post_meta($order_id, self::SHIPPING_METHOD, true);

                if ($method_id !== $this->id) {
                    return;
                }

				if ($order) {

					$omniva = get_option('veebiekspert_module_omniva_params');

					$firstname = $order->get_billing_first_name();
					$lastname = $order->get_billing_last_name();

					if (!empty($order->get_shipping_first_name()) && !empty($order->get_shipping_last_name())) {
						$firstname = $order->get_shipping_first_name();
						$lastname = $order->get_shipping_last_name();
					}

					$name = trim(implode(' ', array($firstname, $lastname)));

					if ($order->get_billing_company()) {
						$name = $order->get_billing_company();
					}

					$phone = $order->get_billing_phone();

					$email = $order->get_billing_email();

					$country = strtoupper(Veebiekspert_Modules()->getOrderShippingCountry($order));
					$prices = eliides_arr_get($omniva, 'prices');
					$price = eliides_arr_get($prices, 'all');

					if (isset($prices[$country])) {
						$price = $prices[$country];
					}

                    $description = [];

                    foreach ($order->get_items() as $orderItem) {
                        $description[] =  $orderItem->get_quantity() . '×' . $name;
                    }

					$params = array(
                        'username' => eliides_arr_get($omniva, 'username'),
                        'password' => eliides_arr_get($omniva, 'password'),
                        'is_test' => eliides_arr_get($omniva, 'is_test'),
                        'reference' => $order_id,
                        'request_type' => eliides_arr_get($omniva, 'request_type'),
                        'service_code' => eliides_arr_get($price, 'service_code'),
                        'sender' => eliides_arr_get($omniva, 'sender'),
                        'recipient' => array(
                            'name' => $name,
                            'phone' => $phone,
                            'email' => $email,
                        ),
                        'description' => implode('; ' , $description),
                        'destination' => array(
                            'zipcode' => $order->get_shipping_postcode(),
                            'city' => $order->get_shipping_city(),
                            'state' => $order->get_shipping_state(),
                            'country' => $order->get_shipping_country(),
                            'address_1' => $order->get_shipping_address_1(),
                            'address_2' => $order->get_shipping_address_2(),
                        ),
                    );

                    $params = apply_filters('eliides_omniva_services_filter', $params, $order_id);

                    if (isset($params['multi_groups'])) {
                        $barcodes = array();
                        $barcodeGroups = array();
                        $groupNr = 0;
                        $reference = $params['reference'];
                        foreach ($params['multi_groups'] as $sendGroup) {
                            $groupNr ++;
                            if ($groupNr > 1) {
                                $params['reference'] = $reference . '-' . $groupNr;
                            }
                            foreach ($sendGroup as $k => $i) {
                                $params[$k] = $i;
                            }
                            unset($params['multi_groups']);

                            $data = $this->sendRequest('send-package', $params);

                            if (isset($data['data']['barcodes']) && !empty($data['data']['barcodes'])) {
                                $barcodeGroups[] = $data['data']['barcodes'];
                                foreach ($data['data']['barcodes'] as $barcode) {
                                    $barcodes[] = $barcode;
                                }
                            }
                            else {
                                //die(print_r($params));
                            }
                        }
                        if (!empty($barcodes)) {
                            update_post_meta($order_id, self::PACKAGE_BARCODE, eliides_sanitize_text_or_array_field($barcodes));
                            update_post_meta($order_id, '_barcode_groups', eliides_sanitize_text_or_array_field($barcodeGroups));
                            do_action('after_eliides_omniva_barcode', $order_id, $barcodes);
                        }
                    }
                    else {
                        $data = $this->sendRequest('send-package', $params);

                        if (isset($data['data']['barcodes']) && !empty($data['data']['barcodes'])) {
                            update_post_meta($order_id, self::PACKAGE_BARCODE, eliides_sanitize_text_or_array_field($data['data']['barcodes']));
                            do_action('after_eliides_omniva_barcode', $order_id, $data['data']['barcodes']);

                            if ($email = eliides_arr_get($omniva, 'send_pdf_copy')) {

                                $pdfResponse = $this->sendRequest('print-label', array(
                                    'username' => eliides_arr_get($omniva, 'username'),
                                    'password' => eliides_arr_get($omniva, 'password'),
                                    'barcodes' => $data['data']['barcodes'],
                                ));

                                $pdf = base64_decode($pdfResponse['data']);
                                $dest = VE_ABS_PATH . 'tmp/' . uniqid() . '.pdf';
                                file_put_contents($dest, $pdf);
                                eliides_send_email_with_attachment($email, 'Pakisilt tellimusele #' . $order_id, '', $dest);
                                unlink($dest);
                            }
                        }
                    }


				}
			}

			public function checkout_update_order_meta($order_id, $post) {

				$shipping_method = eliides_arr_get($post, 'shipping_method');

				if (in_array($this->id, (array) $shipping_method)) {

					update_post_meta($order_id, self::SHIPPING_METHOD, eliides_sanitize_text_or_array_field($this->id));

				}
			}

			public function add_shipping_method( $methods ) {
				$methods[$this->id] = $this;
				return $methods;
			}


			public function sendRequest($action, $params = array()) {
				$apiKey = get_option('veebiekspert_module_omniva_api_key');

				$params['software'] = 'omniva';

				return Veebiekspert_Modules()->getApi()->sendRequest($apiKey, 'omniva', $action, $params);
			}


			/**
			 * This function is used to calculate the shipping cost. Within this function we can check for weights, dimensions and other parameters.
			 *
			 * @access public
			 * @param mixed $package
			 * @return void
			 */
			public function calculate_shipping( $package = array() ) {
                if (!apply_filters('veebiekspert_shipping_method_is_active', true, 'omniva')) {
                    return false;
                }
                $veebiekspert_active_module = get_option('veebiekspert_active_module');

                if (!in_array('omniva', (array) $veebiekspert_active_module)) {
                    return false;
                }

				$country = strtoupper(eliides_arr_get($package, ['destination', 'country']));

				$omniva = get_option('veebiekspert_module_omniva_params');
				$prices = eliides_arr_get($omniva, ['prices']);

				$price = eliides_arr_get($prices, ['all']);

				if (isset($prices[$country])) {
					$price = $prices[$country];
				}

				$prices = $price;

				$items = array();

				$cartTotal = 0;
                $hasFreeShipping = false;

				foreach ($package['contents'] as $content) {
					$cartTotal += $content['line_subtotal'];
                    $product = $content['data'];
                    if ($product->needs_shipping()) {

                        $productId = $product->get_id();
                        if ($parentId = $product->get_parent_id()) {
                            $productId = $parentId;
                        }
                        if (get_post_meta($productId, '_no_shipping_cost', true) == 'yes') {
                            $hasFreeShipping = true;
                        }
                    }
				}

				$hasCoupon = false;

				if (WC()->cart->applied_coupons) {
					foreach (WC()->cart->applied_coupons as $code) {
						$coupon = new WC_Coupon($code);
                        if ($coupon->is_valid_for_cart() && $coupon->get_free_shipping()) {
							$hasCoupon = true;
							break;
						}
					}
				}

				if ($hasFreeShipping || $hasCoupon || (strlen($prices['free_from']) > 0 && $prices['free_from'] <= $cartTotal)) {

					$price = 0;

				}
				else {

					$price = $prices['price'];

				}

				$rate = array(
					'id' => $this->id,
					'label' => $this->title,
					'cost' =>  $price
				);

				$this->add_rate( $rate );
			}


		}

    endif;

    new Veebiekspert_Transport_Omniva();


}

add_action('plugins_loaded', 'eliides_init_omniva');


